/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Log
extends AbstractField<BigDecimal> {
    private final Field<? extends Number> value;
    private final Field<? extends Number> base;

    Log(Field<? extends Number> value) {
        super(Names.N_LOG, Tools.allNotNull(SQLDataType.NUMERIC, value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.base = null;
    }

    Log(Field<? extends Number> value, Field<? extends Number> base) {
        super(Names.N_LOG, Tools.allNotNull(SQLDataType.NUMERIC, value, base));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.base = Tools.nullSafeNotNull(base, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.base == null) {
            switch (ctx.family()) {
                default: 
            }
            ctx.visit(DSL.function(Names.N_LN, SQLDataType.NUMERIC, this.value));
            return;
        }
        switch (ctx.family()) {
            case DERBY: 
            case HSQLDB: 
            case IGNITE: {
                ctx.visit(Internal.idiv(DSL.ln(this.value), DSL.ln(this.base)));
                return;
            }
        }
        ctx.visit(DSL.function(Names.N_LOG, SQLDataType.NUMERIC, this.base, this.value));
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Log) {
            return StringUtils.equals(this.value, ((Log)that).value) && StringUtils.equals(this.base, ((Log)that).base);
        }
        return super.equals(that);
    }
}

