/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Left
extends AbstractField<String> {
    private final Field<String> string;
    private final Field<? extends Number> length;

    Left(Field<String> string, Field<? extends Number> length) {
        super(Names.N_LEFT, Tools.allNotNull(SQLDataType.VARCHAR, string, length));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.length = Tools.nullSafeNotNull(length, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: 
            case SQLITE: {
                ctx.visit(DSL.substring(this.string, DSL.inline(1), this.length));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_LEFT, this.getDataType(), this.string, this.length));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Left) {
            return StringUtils.equals(this.string, ((Left)that).string) && StringUtils.equals(this.length, ((Left)that).length);
        }
        return super.equals(that);
    }
}

