/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONArrayNullStep;
import org.jooq.JSONArrayReturningStep;
import org.jooq.QueryPart;
import org.jooq.Row1;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;
import org.jooq.impl.JSONEntryImpl;
import org.jooq.impl.JSONNull;
import org.jooq.impl.JSONOnNull;
import org.jooq.impl.JSONReturning;
import org.jooq.impl.Names;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class JSONArray<T>
extends AbstractField<T>
implements JSONArrayNullStep<T>,
JSONArrayReturningStep<T> {
    private final DataType<T> type;
    private final Collection<? extends Field<?>> fields;
    private JSONOnNull onNull;
    private DataType<?> returning;

    JSONArray(DataType<T> type, Collection<? extends Field<?>> fields) {
        this(type, fields, null, null);
    }

    JSONArray(DataType<T> type, Collection<? extends Field<?>> fields, JSONOnNull onNull, DataType<?> returning) {
        super(Names.N_JSON_ARRAY, type);
        this.type = type;
        this.fields = fields;
        this.onNull = onNull;
        this.returning = returning;
    }

    @Override
    public final JSONArray<T> nullOnNull() {
        this.onNull = JSONOnNull.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONArray<T> absentOnNull() {
        this.onNull = JSONOnNull.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONArray<T> returning(DataType<?> returning) {
        this.returning = returning;
        return this;
    }

    @Override
    public void accept(Context<?> ctx) {
        QueryPartCollectionView<Field<?>> mapped = QueryPartCollectionView.wrap(this.fields).map(JSONEntryImpl.jsonCastMapper(ctx));
        switch (ctx.family()) {
            case POSTGRES: {
                if (this.onNull == JSONOnNull.ABSENT_ON_NULL && !mapped.isEmpty()) {
                    Row1[] rows = Tools.map(this.fields, f -> DSL.row(f), Row1[]::new);
                    Table t2 = DSL.values(rows).as("t", "a");
                    Field<?> a = t2.field("a");
                    ctx.visit(DSL.field(DSL.select(this.getDataType() == SQLDataType.JSON ? DSL.jsonArrayAgg(a) : DSL.jsonbArrayAgg(a)).from((TableLike<?>)t2).where(a.isNotNull())));
                    break;
                }
                ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_BUILD_ARRAY : Names.N_JSONB_BUILD_ARRAY).sql('(').visit(mapped).sql(')');
                break;
            }
            default: {
                JSONNull jsonNull = ctx.family() == SQLDialect.H2 && this.fields.isEmpty() ? new JSONNull(JSONOnNull.NULL_ON_NULL) : new JSONNull(this.onNull);
                JSONReturning jsonReturning = new JSONReturning(this.returning);
                CustomField jsonArray = CustomField.of(Names.N_JSON_ARRAY, this.getDataType(), c -> c.visit(Names.N_JSON_ARRAY).sql('(').visit(QueryPartListView.wrap((QueryPart[])new AbstractQueryPart[]{mapped, jsonNull, jsonReturning}).separator("")).sql(')'));
                switch (ctx.family()) {
                    default: 
                }
                ctx.visit(jsonArray);
                break;
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof JSONArray) {
            return StringUtils.equals(this.type, ((JSONArray)that).type) && StringUtils.equals(this.fields, ((JSONArray)that).fields) && StringUtils.equals((Object)this.onNull, (Object)((JSONArray)that).onNull) && StringUtils.equals(this.returning, ((JSONArray)that).returning);
        }
        return super.equals(that);
    }
}

