/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.Merge;
import org.jooq.MergeMatchedStep;
import org.jooq.MergeOnConditionStep;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractStoreQuery;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldMapForUpdate;
import org.jooq.impl.FieldMapsForInsert;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;
import org.jooq.tools.StringUtils;

final class InsertQueryImpl<R extends Record>
extends AbstractStoreQuery<R>
implements InsertQuery<R> {
    private static final Clause[] CLAUSES = new Clause[]{Clause.INSERT};
    private static final Set<SQLDialect> SUPPORT_INSERT_IGNORE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> NO_SUPPORT_DERIVED_COLUMN_LIST_IN_MERGE_USING = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.H2);
    private static final Set<SQLDialect> NO_SUPPORT_SUBQUERY_IN_MERGE_USING = SQLDialect.supportedBy(SQLDialect.DERBY);
    private final FieldMapForUpdate updateMap;
    private final FieldMapsForInsert insertMaps;
    private Select<?> select;
    private boolean defaultValues;
    private boolean onDuplicateKeyUpdate;
    private boolean onDuplicateKeyIgnore;
    private Constraint onConstraint;
    private UniqueKey<R> onConstraintUniqueKey;
    private QueryPartList<Field<?>> onConflict;
    private final ConditionProviderImpl onConflictWhere;
    private final ConditionProviderImpl condition;

    InsertQueryImpl(Configuration configuration, WithImpl with, Table<R> into) {
        super(configuration, with, into);
        this.updateMap = new FieldMapForUpdate(into, Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
        this.insertMaps = new FieldMapsForInsert(into);
        this.onConflictWhere = new ConditionProviderImpl();
        this.condition = new ConditionProviderImpl();
    }

    @Override
    public final void newRecord() {
        this.insertMaps.newRecord();
    }

    @Override
    protected final Map<Field<?>, Field<?>> getValues() {
        return this.insertMaps.lastMap();
    }

    final FieldMapsForInsert getInsertMaps() {
        return this.insertMaps;
    }

    final Select<?> getSelect() {
        return this.select;
    }

    @Override
    public final void addRecord(R record) {
        this.newRecord();
        this.setRecord(record);
    }

    @Override
    public final void onConflict(Field<?> ... fields) {
        this.onConflict(Arrays.asList(fields));
    }

    @Override
    public final void onConflict(Collection<? extends Field<?>> fields) {
        this.onConflict = new QueryPartList((Iterable<Field<?>>)fields).qualify(false);
    }

    @Override
    public final void onConflictWhere(Condition conditions) {
        this.onConflictWhere.addConditions(conditions);
    }

    @Override
    public final void onConflictOnConstraint(Constraint constraint) {
        this.onConflictOnConstraint0(constraint);
    }

    @Override
    public void onConflictOnConstraint(UniqueKey<R> constraint) {
        if (StringUtils.isEmpty(constraint.getName())) {
            throw new IllegalArgumentException("UniqueKey's name is not specified");
        }
        this.onConstraintUniqueKey = constraint;
        this.onConflictOnConstraint0(DSL.constraint(DSL.name(constraint.getName())));
    }

    @Override
    public final void onConflictOnConstraint(Name constraint) {
        this.onConflictOnConstraint0(DSL.constraint(constraint));
    }

    private void onConflictOnConstraint0(Constraint constraint) {
        this.onConstraint = constraint;
        if (this.onConstraintUniqueKey == null) {
            this.onConstraintUniqueKey = Tools.findAny(this.table().getKeys(), key -> constraint.getName().equals(key.getName()));
        }
    }

    @Override
    public final void onDuplicateKeyUpdate(boolean flag) {
        this.onDuplicateKeyIgnore = false;
        this.onDuplicateKeyUpdate = flag;
    }

    @Override
    public final void onDuplicateKeyIgnore(boolean flag) {
        this.onDuplicateKeyUpdate = false;
        this.onDuplicateKeyIgnore = flag;
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, T value) {
        this.updateMap.put(field, Tools.field(value, field));
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, Field<T> value) {
        this.updateMap.put(field, Tools.field(value, field));
    }

    @Override
    public final void addValuesForUpdate(Map<?, ?> map) {
        this.updateMap.set(map);
    }

    @Override
    public final void addConditions(Condition conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Condition ... conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Collection<? extends Condition> conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition ... conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Collection<? extends Condition> conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void setDefaultValues() {
        this.defaultValues = true;
    }

    @Override
    public final void setSelect(Field<?>[] f, Select<?> s2) {
        this.setSelect(Arrays.asList(f), s2);
    }

    @Override
    public final void setSelect(Collection<? extends Field<?>> f, Select<?> s2) {
        this.insertMaps.addFields(f);
        this.select = s2;
    }

    @Override
    public final void addValues(Map<?, ?> map) {
        this.insertMaps.set(map);
    }

    @Override
    final void accept0(Context<?> ctx) {
        if (this.onDuplicateKeyUpdate) {
            switch (ctx.family()) {
                case POSTGRES: 
                case SQLITE: {
                    ctx.data((Object)Tools.BooleanDataKey.DATA_MANDATORY_WHERE_CLAUSE, ctx.family() == SQLDialect.SQLITE, c -> this.toSQLInsert((Context<?>)c));
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_CONFLICT).sql(' ');
                    if (this.onConstraint != null) {
                        ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true);
                        ctx.visit(Keywords.K_ON_CONSTRAINT).sql(' ').visit(this.onConstraint);
                        ctx.data().remove((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE);
                    } else {
                        ctx.sql('(');
                        if (this.onConflict != null && this.onConflict.size() > 0) {
                            ctx.visit(this.onConflict);
                        } else if (this.table().getPrimaryKey() == null) {
                            ctx.sql("[unknown primary key]");
                        } else {
                            ctx.qualify(false, c -> c.visit(new FieldsImpl(this.table().getPrimaryKey().getFields())));
                        }
                        ctx.sql(')');
                    }
                    this.acceptOnConflictWhere(ctx);
                    ctx.formatSeparator().visit(Keywords.K_DO_UPDATE).formatSeparator().visit(Keywords.K_SET).formatIndentStart().formatSeparator().visit(this.updateMap).formatIndentEnd();
                    if (this.condition.hasWhere()) {
                        ctx.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(this.condition);
                    }
                    ctx.end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: {
                    ctx.visit(this.toMerge(ctx.configuration()));
                    break;
                }
                default: {
                    boolean oldQualify = ctx.qualify();
                    boolean newQualify = ctx.family() != SQLDialect.H2 && oldQualify;
                    this.toSQLInsert(ctx);
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_DUPLICATE_KEY_UPDATE).formatIndentStart().formatSeparator().qualify(newQualify);
                    if (this.condition.hasWhere()) {
                        ctx.data((Object)Tools.DataKey.DATA_ON_DUPLICATE_KEY_WHERE, this.condition.getWhere());
                    }
                    ctx.visit(this.updateMap);
                    if (this.condition.hasWhere()) {
                        ctx.data().remove((Object)Tools.DataKey.DATA_ON_DUPLICATE_KEY_WHERE);
                    }
                    ctx.qualify(oldQualify).formatIndentEnd().end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
            }
        } else if (this.onDuplicateKeyIgnore) {
            switch (ctx.dialect()) {
                case MYSQL: 
                case MARIADB: {
                    this.toSQLInsert(ctx);
                    ctx.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case POSTGRES: 
                case SQLITE: {
                    ctx.data((Object)Tools.BooleanDataKey.DATA_MANDATORY_WHERE_CLAUSE, ctx.family() == SQLDialect.SQLITE, c -> this.toSQLInsert((Context<?>)c));
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_CONFLICT);
                    if (this.onConstraint != null) {
                        ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true, c -> c.sql(' ').visit(Keywords.K_ON_CONSTRAINT).sql(' ').visit(this.onConstraint));
                    } else if (this.onConflict != null && this.onConflict.size() > 0) {
                        ctx.sql(" (").visit(this.onConflict).sql(')');
                        this.acceptOnConflictWhere(ctx);
                    }
                    ctx.formatSeparator().visit(Keywords.K_DO_NOTHING).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case CUBRID: {
                    FieldMapForUpdate update = new FieldMapForUpdate(this.table(), Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
                    Field<?> field = this.table().field(0);
                    update.put(field, field);
                    this.toSQLInsert(ctx);
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_DUPLICATE_KEY_UPDATE).sql(' ').visit(update).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case H2: 
                case HSQLDB: {
                    ctx.visit(this.toMerge(ctx.configuration()));
                    break;
                }
                case DERBY: {
                    if (this.select != null) {
                        ctx.visit(this.toInsertSelect(ctx.configuration()));
                        break;
                    }
                    ctx.visit(this.toMerge(ctx.configuration()));
                    break;
                }
                default: {
                    ctx.visit(this.toInsertSelect(ctx.configuration()));
                    break;
                }
            }
        } else {
            this.toSQLInsert(ctx);
            ctx.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
        }
        ctx.start(Clause.INSERT_RETURNING);
        this.toSQLReturning(ctx);
        ctx.end(Clause.INSERT_RETURNING);
    }

    private final void acceptOnConflictWhere(Context<?> ctx) {
        if (this.onConflictWhere.hasWhere()) {
            ctx.qualify(false, c -> c.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(this.onConflictWhere.getWhere()));
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private final void toSQLInsert(Context<?> ctx) {
        ctx.start(Clause.INSERT_INSERT_INTO).visit(Keywords.K_INSERT).sql(' ');
        if (this.onDuplicateKeyIgnore && SUPPORT_INSERT_IGNORE.contains((Object)ctx.dialect())) {
            ctx.visit(Keywords.K_IGNORE).sql(' ');
        }
        ctx.visit(Keywords.K_INTO).sql(' ').declareTables(true, c -> c.visit(this.table((Context<?>)c)));
        this.insertMaps.toSQLReferenceKeys(ctx);
        ctx.end(Clause.INSERT_INSERT_INTO);
        if (this.select != null) {
            if (this.insertMaps.fields().size() == 0) {
                ctx.data((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST, true);
            }
            ctx.data((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT, true);
            ctx.formatSeparator().start(Clause.INSERT_SELECT).visit(this.select).end(Clause.INSERT_SELECT);
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST);
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT);
        } else if (this.defaultValues) {
            switch (ctx.family()) {
                case DERBY: 
                case MYSQL: 
                case MARIADB: {
                    this.acceptDefaultValuesEmulation(ctx, this.table().fields().length);
                    break;
                }
                default: {
                    ctx.formatSeparator().visit(Keywords.K_DEFAULT_VALUES);
                    break;
                }
            }
        } else {
            ctx.visit(this.insertMaps);
        }
    }

    private final void acceptDefaultValuesEmulation(Context<?> ctx, int length) {
        ctx.formatSeparator().visit(Keywords.K_VALUES).sql(" (").visit(QueryPartListView.wrap(Collections.nCopies(length, Keywords.K_DEFAULT))).sql(')');
    }

    private final List<List<? extends Field<?>>> conflictingKeys(Configuration configuration) {
        if (this.onConflict != null && this.onConflict.size() > 0) {
            return Collections.singletonList(this.onConflict);
        }
        if (this.onConstraintUniqueKey != null) {
            return Collections.singletonList(this.onConstraintUniqueKey.getFields());
        }
        if (Boolean.TRUE.equals(Tools.settings(configuration).isEmulateOnDuplicateKeyUpdateOnPrimaryKeyOnly())) {
            return Collections.singletonList(this.table().getPrimaryKey().getFields());
        }
        return Tools.map(this.table().getKeys(), k -> k.getFields());
    }

    private final QueryPart toInsertSelect(Configuration configuration) {
        List<List<Field<?>>> keys = this.conflictingKeys(configuration);
        if (!keys.isEmpty()) {
            Select rows = null;
            if (this.select != null) {
                HashMap map = new HashMap();
                Field<?>[] names = Tools.fields(Tools.degree(this.select));
                ArrayList fields = new ArrayList(this.insertMaps.fields());
                for (int i = 0; i < fields.size() && i < names.length; ++i) {
                    map.put((Field)fields.get(i), names[i]);
                }
                rows = DSL.selectFrom(this.select.asTable(DSL.table(DSL.name("t")), names)).whereNotExists(DSL.selectOne().from((TableLike<?>)this.table()).where(this.matchByConflictingKeys(configuration, map)));
            } else {
                for (Map<Field<?>, Field<?>> map : this.insertMaps.maps()) {
                    SelectConditionStep row = DSL.select(Tools.aliasedFields(map.values())).whereNotExists(DSL.selectOne().from((TableLike<?>)this.table()).where(this.matchByConflictingKeys(configuration, map)));
                    if (rows == null) {
                        rows = row;
                        continue;
                    }
                    rows = rows.unionAll(row);
                }
            }
            return configuration.dsl().insertInto(this.table()).columns(this.insertMaps.fields()).select(DSL.selectFrom(rows.asTable("t")));
        }
        throw new IllegalStateException("The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be emulated when inserting into tables without any known keys : " + this.table());
    }

    private final Merge<R> toMerge(Configuration configuration) {
        if (this.onConflict != null && this.onConflict.size() > 0 || this.onConstraint != null || !this.table().getKeys().isEmpty()) {
            MergeOnConditionStep on;
            Table t2 = null;
            Collection<Field<?>> f = null;
            if (!NO_SUPPORT_SUBQUERY_IN_MERGE_USING.contains((Object)configuration.dialect())) {
                Select<Object> s2;
                f = this.insertMaps.fields().isEmpty() ? Arrays.asList(this.table().fields()) : this.insertMaps.fields();
                Select<Object> select = s2 = this.select != null ? this.select : this.insertMaps.insertSelect();
                if (s2 == null) {
                    s2 = DSL.select(Tools.map(f, x -> x.getDataType().defaulted() ? x.getDataType().default_() : DSL.NULL(x)));
                }
                t2 = s2.asTable("t", Tools.map(f, Field::getName, String[]::new));
                if (NO_SUPPORT_DERIVED_COLUMN_LIST_IN_MERGE_USING.contains((Object)configuration.dialect())) {
                    t2 = DSL.selectFrom(t2).asTable("t");
                }
            }
            MergeMatchedStep notMatched = on = t2 != null ? configuration.dsl().mergeInto(this.table()).using(t2).on(this.matchByConflictingKeys(configuration, t2)) : configuration.dsl().mergeInto(this.table()).usingDual().on(this.matchByConflictingKeys(configuration, this.insertMaps.lastMap()));
            if (this.onDuplicateKeyUpdate) {
                notMatched = this.condition.hasWhere() ? on.whenMatchedAnd(this.condition.getWhere()).thenUpdate().set(this.updateMap) : on.whenMatchedThenUpdate().set(this.updateMap);
            }
            return t2 != null ? notMatched.whenNotMatchedThenInsert(f).values(t2.fields()) : notMatched.whenNotMatchedThenInsert(this.insertMaps.fields()).values(this.insertMaps.lastMap().values());
        }
        throw new IllegalStateException("The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be emulated when inserting into non-updatable tables : " + this.table());
    }

    private final Condition matchByConflictingKeys(Configuration configuration, Map<Field<?>, Field<?>> map) {
        Condition or = null;
        if (this.onConstraint != null && this.onConstraintUniqueKey == null) {
            return DSL.condition("[ cannot create predicate from constraint with unknown columns ]");
        }
        for (List<Field<?>> fields : this.conflictingKeys(configuration)) {
            Condition and = null;
            Iterator<Field<?>> iterator = fields.iterator();
            while (iterator.hasNext()) {
                Field<?> field;
                Field<?> f = field = iterator.next();
                Field<?> v = map.get(f);
                Condition other = f.eq(v);
                and = and == null ? other : and.and(other);
            }
            or = or == null ? and : or.or(and);
        }
        return or;
    }

    private final Condition matchByConflictingKeys(Configuration configuration, Table<?> s2) {
        Condition or = null;
        if (this.onConstraint != null && this.onConstraintUniqueKey == null) {
            return DSL.condition("[ cannot create predicate from constraint with unknown columns ]");
        }
        for (List<Field<?>> fields : this.conflictingKeys(configuration)) {
            Condition and = null;
            Iterator<Field<?>> iterator = fields.iterator();
            while (iterator.hasNext()) {
                Field<?> field;
                Field<?> f = field = iterator.next();
                Field<?> v = s2.field(f);
                Condition other = f.eq(v);
                and = and == null ? other : and.and(other);
            }
            or = or == null ? and : or.or(and);
        }
        return or;
    }

    @Override
    public final boolean isExecutable() {
        return this.insertMaps.isExecutable() || this.defaultValues || this.select != null;
    }
}

