/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class FieldFunction<T>
extends AbstractField<Integer> {
    private final QueryPartListView<Field<?>> arguments;

    FieldFunction(Field<T> field, Field<T>[] arguments) {
        super(Names.N_FIELD, SQLDataType.INTEGER);
        this.arguments = QueryPartListView.wrap((QueryPart[])Tools.combine(field, arguments));
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.arguments.size() > 1) {
                    ctx.visit(Names.N_FIELD).sql('(').visit(this.arguments).sql(')');
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptDefault(Context<?> ctx) {
        int size = this.arguments.size();
        if (size == 1) {
            ctx.visit(DSL.zero());
        } else {
            ArrayList<Field> args = new ArrayList<Field>();
            args.add((Field)this.arguments.get(0));
            for (int i = 1; i < size; ++i) {
                args.add((Field)this.arguments.get(i));
                args.add(DSL.inline(i));
            }
            args.add(DSL.inline(0));
            ctx.visit(DSL.decode((Field)args.get(0), (Field)args.get(1), (Field)args.get(2), (Object[])args.subList(3, args.size()).toArray(Tools.EMPTY_FIELD)));
        }
    }
}

