/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jooq.impl.AbstractConverter;
import org.jooq.tools.Convert;
import org.jooq.tools.reflect.Reflect;

public class EnumConverter<T, U extends Enum<U>>
extends AbstractConverter<T, U> {
    private final Map<T, U> lookup;
    private final EnumType enumType;

    public EnumConverter(Class<T> fromType, Class<U> toType) {
        super(fromType, toType);
        this.enumType = Number.class.isAssignableFrom(Reflect.wrapper(fromType)) ? EnumType.ORDINAL : EnumType.STRING;
        this.lookup = new LinkedHashMap<T, U>();
        for (Enum u : (Enum[])toType.getEnumConstants()) {
            this.lookup.put(this.to((U)u), u);
        }
    }

    @Override
    public final U from(T databaseObject) {
        return (U)((Enum)this.lookup.get(databaseObject));
    }

    @Override
    public T to(U userObject) {
        if (userObject == null) {
            return null;
        }
        if (this.enumType == EnumType.ORDINAL) {
            return Convert.convert((Object)((Enum)userObject).ordinal(), this.fromType());
        }
        return Convert.convert((Object)((Enum)userObject).name(), this.fromType());
    }

    @Override
    public String toString() {
        return "EnumConverter [ " + this.fromType().getName() + " -> " + this.toType().getName() + " ]";
    }

    static enum EnumType {
        ORDINAL,
        STRING;

    }
}

