/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropViewFinalStep;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropViewImpl
extends AbstractDDLQuery
implements DropViewFinalStep {
    private final Table<?> view;
    private final boolean dropViewIfExists;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    DropViewImpl(Configuration configuration, Table<?> view, boolean dropViewIfExists) {
        super(configuration);
        this.view = view;
        this.dropViewIfExists = dropViewIfExists;
    }

    final Table<?> $view() {
        return this.view;
    }

    final boolean $dropViewIfExists() {
        return this.dropViewIfExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.dropViewIfExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_VIEW, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_VIEW_TABLE).visit(Keywords.K_DROP_VIEW).sql(' ');
        if (this.dropViewIfExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        ctx.end(Clause.DROP_VIEW_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

