/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropTableFinalStep;
import org.jooq.DropTableStep;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.Cascade;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropTableImpl
extends AbstractDDLQuery
implements DropTableStep,
DropTableFinalStep {
    private final Boolean temporary;
    private final Table<?> table;
    private final boolean dropTableIfExists;
    private Cascade cascade;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_TABLE};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> TEMPORARY_SEMANTIC = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);

    DropTableImpl(Configuration configuration, Boolean temporary, Table<?> table, boolean dropTableIfExists) {
        this(configuration, temporary, table, dropTableIfExists, null);
    }

    DropTableImpl(Configuration configuration, Boolean temporary, Table<?> table, boolean dropTableIfExists, Cascade cascade) {
        super(configuration);
        this.temporary = temporary;
        this.table = table;
        this.dropTableIfExists = dropTableIfExists;
        this.cascade = cascade;
    }

    final Boolean $temporary() {
        return this.temporary;
    }

    final Table<?> $table() {
        return this.table;
    }

    final boolean $dropTableIfExists() {
        return this.dropTableIfExists;
    }

    final Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final DropTableImpl cascade() {
        this.cascade = Cascade.CASCADE;
        return this;
    }

    @Override
    public final DropTableImpl restrict() {
        this.cascade = Cascade.RESTRICT;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.dropTableIfExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_TABLE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_TABLE_TABLE);
        if (this.temporary.booleanValue() && TEMPORARY_SEMANTIC.contains((Object)ctx.dialect())) {
            ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_TEMPORARY).sql(' ').visit(Keywords.K_TABLE).sql(' ');
        } else {
            ctx.visit(Keywords.K_DROP_TABLE).sql(' ');
        }
        if (this.dropTableIfExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.table);
        DropTableImpl.acceptCascade(ctx, this.cascade);
        ctx.end(Clause.DROP_TABLE_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

