/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropIndexCascadeStep;
import org.jooq.DropIndexFinalStep;
import org.jooq.DropIndexOnStep;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.Cascade;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropIndexImpl
extends AbstractDDLQuery
implements DropIndexOnStep,
DropIndexCascadeStep,
DropIndexFinalStep {
    private final Index index;
    private final boolean dropIndexIfExists;
    private Table<?> on;
    private Cascade cascade;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_INDEX};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> REQUIRES_ON = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);

    DropIndexImpl(Configuration configuration, Index index, boolean dropIndexIfExists) {
        this(configuration, index, dropIndexIfExists, null, null);
    }

    DropIndexImpl(Configuration configuration, Index index, boolean dropIndexIfExists, Table<?> on, Cascade cascade) {
        super(configuration);
        this.index = index;
        this.dropIndexIfExists = dropIndexIfExists;
        this.on = on;
        this.cascade = cascade;
    }

    final Index $index() {
        return this.index;
    }

    final boolean $dropIndexIfExists() {
        return this.dropIndexIfExists;
    }

    final Table<?> $on() {
        return this.on;
    }

    final Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final DropIndexImpl on(String on) {
        return this.on((Table)DSL.table(DSL.name(on)));
    }

    @Override
    public final DropIndexImpl on(Name on) {
        return this.on((Table)DSL.table(on));
    }

    @Override
    public final DropIndexImpl on(Table<?> on) {
        this.on = on;
        return this;
    }

    @Override
    public final DropIndexImpl cascade() {
        this.cascade = Cascade.CASCADE;
        return this;
    }

    @Override
    public final DropIndexImpl restrict() {
        this.cascade = Cascade.RESTRICT;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.dropIndexIfExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_INDEX, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_DROP_INDEX).sql(' ');
        if (this.dropIndexIfExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.index);
        if (REQUIRES_ON.contains((Object)ctx.dialect())) {
            if (this.on != null) {
                ctx.sql(' ').visit(Keywords.K_ON).sql(' ').visit(this.on);
            } else if (this.index.getTable() != null) {
                ctx.sql(' ').visit(Keywords.K_ON).sql(' ').visit(this.index.getTable());
            }
        }
        DropIndexImpl.acceptCascade(ctx, this.cascade);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

