/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateIndexFinalStep;
import org.jooq.CreateIndexIncludeStep;
import org.jooq.CreateIndexStep;
import org.jooq.CreateIndexWhereStep;
import org.jooq.Field;
import org.jooq.Index;
import org.jooq.Keyword;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.Tools;

final class CreateIndexImpl
extends AbstractDDLQuery
implements CreateIndexStep,
CreateIndexIncludeStep,
CreateIndexWhereStep,
CreateIndexFinalStep {
    private final Boolean unique;
    private final Index index;
    private final boolean createIndexIfNotExists;
    private Table<?> table;
    private Collection<? extends OrderField<?>> on;
    private Collection<? extends Field<?>> include;
    private Condition where;
    private boolean excludeNullKeys;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_INDEX};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> SUPPORT_UNNAMED_INDEX = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> SUPPORT_INCLUDE = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> SUPPORT_UNIQUE_INCLUDE = SQLDialect.supportedBy(SQLDialect.POSTGRES);

    CreateIndexImpl(Configuration configuration, Boolean unique, Index index, boolean createIndexIfNotExists) {
        this(configuration, unique, index, createIndexIfNotExists, null, null, null, null, false);
    }

    CreateIndexImpl(Configuration configuration, Boolean unique, boolean createIndexIfNotExists) {
        this(configuration, unique, null, createIndexIfNotExists);
    }

    CreateIndexImpl(Configuration configuration, Boolean unique, Index index, boolean createIndexIfNotExists, Table<?> table, Collection<? extends OrderField<?>> on, Collection<? extends Field<?>> include, Condition where, boolean excludeNullKeys) {
        super(configuration);
        this.unique = unique;
        this.index = index;
        this.createIndexIfNotExists = createIndexIfNotExists;
        this.table = table;
        this.on = on;
        this.include = include;
        this.where = where;
        this.excludeNullKeys = excludeNullKeys;
    }

    final Boolean $unique() {
        return this.unique;
    }

    final Index $index() {
        return this.index;
    }

    final boolean $createIndexIfNotExists() {
        return this.createIndexIfNotExists;
    }

    final Table<?> $table() {
        return this.table;
    }

    final Collection<? extends OrderField<?>> $on() {
        return this.on;
    }

    final Collection<? extends Field<?>> $include() {
        return this.include;
    }

    final Condition $where() {
        return this.where;
    }

    final boolean $excludeNullKeys() {
        return this.excludeNullKeys;
    }

    @Override
    public final CreateIndexImpl on(String table, String ... on) {
        return this.on((Table)DSL.table(DSL.name(table)), Tools.fieldsByName(on));
    }

    @Override
    public final CreateIndexImpl on(Name table, Name ... on) {
        return this.on((Table)DSL.table(table), Tools.fieldsByName(on));
    }

    @Override
    public final CreateIndexImpl on(Table<?> table, OrderField<?> ... on) {
        return this.on((Table)table, (Collection)Arrays.asList(on));
    }

    @Override
    public final CreateIndexImpl on(String table, Collection<? extends String> on) {
        return this.on((Table)DSL.table(DSL.name(table)), Tools.fieldsByName(on.toArray(Tools.EMPTY_STRING)));
    }

    @Override
    public final CreateIndexImpl on(Name table, Collection<? extends Name> on) {
        return this.on((Table)DSL.table(table), Tools.fieldsByName(on.toArray(Tools.EMPTY_NAME)));
    }

    @Override
    public final CreateIndexImpl on(Table<?> table, Collection<? extends OrderField<?>> on) {
        this.table = table;
        this.on = on;
        return this;
    }

    @Override
    public final CreateIndexImpl include(String ... include) {
        return this.include((Field[])Tools.fieldsByName(include));
    }

    @Override
    public final CreateIndexImpl include(Name ... include) {
        return this.include((Field[])Tools.fieldsByName(include));
    }

    @Override
    public final CreateIndexImpl include(Field<?> ... include) {
        return this.include(Arrays.asList(include));
    }

    @Override
    public final CreateIndexImpl include(Collection<? extends Field<?>> include) {
        this.include = include;
        return this;
    }

    @Override
    public final CreateIndexImpl where(Field<Boolean> where) {
        return this.where(DSL.condition(where));
    }

    @Override
    public final CreateIndexImpl where(Condition ... where) {
        return this.where(DSL.condition(Operator.AND, where));
    }

    @Override
    public final CreateIndexImpl where(Collection<? extends Condition> where) {
        return this.where(DSL.condition(Operator.AND, where));
    }

    @Override
    public final CreateIndexImpl where(Condition where) {
        this.where = where;
        return this;
    }

    @Override
    public final CreateIndexImpl where(String where, QueryPart ... parts) {
        return this.where(DSL.condition(where, parts));
    }

    @Override
    public final CreateIndexImpl where(String where, Object ... bindings) {
        return this.where(DSL.condition(where, bindings));
    }

    @Override
    public final CreateIndexImpl where(String where) {
        return this.where(DSL.condition(where));
    }

    @Override
    public final CreateIndexImpl where(SQL where) {
        return this.where(DSL.condition(where));
    }

    @Override
    public final CreateIndexImpl excludeNullKeys() {
        this.excludeNullKeys = true;
        return this;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.createIndexIfNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_INDEX, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        Condition condition;
        ctx.visit(Keywords.K_CREATE);
        if (this.unique.booleanValue()) {
            ctx.sql(' ').visit(Keywords.K_UNIQUE);
        }
        ctx.sql(' ').visit(Keywords.K_INDEX).sql(' ');
        if (this.createIndexIfNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        if (this.index != null) {
            ctx.visit(this.index).sql(' ');
        } else if (!SUPPORT_UNNAMED_INDEX.contains((Object)ctx.dialect())) {
            ctx.visit(this.generatedName()).sql(' ');
        }
        boolean supportsInclude = this.unique != false ? SUPPORT_UNIQUE_INCLUDE.contains((Object)ctx.dialect()) : SUPPORT_INCLUDE.contains((Object)ctx.dialect());
        boolean supportsFieldsBeforeTable = false;
        QueryPartListView list = new QueryPartList().qualify(false);
        list.addAll(this.on);
        if (!supportsInclude && !this.unique.booleanValue() && this.include != null) {
            list.addAll(this.include);
        }
        ctx.visit(Keywords.K_ON).sql(' ').visit(this.table);
        ctx.sql('(').visit(list).sql(')');
        if (supportsInclude && this.include != null) {
            Keyword keyword = Keywords.K_INCLUDE;
            ctx.formatSeparator().visit(keyword).sql(" (").visit(QueryPartCollectionView.wrap(this.include).qualify(false)).sql(')');
        }
        if ((condition = this.excludeNullKeys && this.where == null ? (this.on.size() == 1 ? Tools.field(Tools.first(this.on)).isNotNull() : DSL.row(Tools.fields(this.on)).isNotNull()) : this.where) != null && ctx.configuration().data("org.jooq.ddl.ignore-storage-clauses") == null) {
            ctx.formatSeparator().visit(Keywords.K_WHERE).sql(' ').qualify(false, c -> c.visit(condition));
        }
    }

    private final Name generatedName() {
        Name t2 = this.table.getQualifiedName();
        StringBuilder sb = new StringBuilder(this.table.getName());
        for (OrderField<?> f : this.on) {
            sb.append('_').append(Tools.field(f).getName());
        }
        sb.append("_idx");
        if (t2.qualified()) {
            return t2.qualifier().append(sb.toString());
        }
        return DSL.name(sb.toString());
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

