/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateDatabaseFinalStep;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class CreateDatabaseImpl
extends AbstractDDLQuery
implements CreateDatabaseFinalStep {
    private final Catalog database;
    private final boolean createDatabaseIfNotExists;
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.POSTGRES);

    CreateDatabaseImpl(Configuration configuration, Catalog database, boolean createDatabaseIfNotExists) {
        super(configuration);
        this.database = database;
        this.createDatabaseIfNotExists = createDatabaseIfNotExists;
    }

    final Catalog $database() {
        return this.database;
    }

    final boolean $createDatabaseIfNotExists() {
        return this.createDatabaseIfNotExists;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.createDatabaseIfNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_DATABASE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_CREATE).sql(' ').visit(Keywords.K_DATABASE);
        if (this.createDatabaseIfNotExists && this.supportsIfNotExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_NOT_EXISTS);
        }
        ctx.sql(' ').visit(this.database);
    }
}

