/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultAggregateFunction;
import org.jooq.impl.SQLDataType;

final class CountTable
extends DefaultAggregateFunction<Integer> {
    private final Table<?> table;

    CountTable(Table<?> table, boolean distinct) {
        super(distinct, "count", SQLDataType.INTEGER, DSL.field(DSL.name(table.getName())));
        this.table = table;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                super.accept(ctx);
                break;
            }
            default: {
                UniqueKey<?> pk = this.table.getPrimaryKey();
                if (pk != null) {
                    ctx.visit(new DefaultAggregateFunction<Integer>(this.distinct, "count", SQLDataType.INTEGER, this.table.fields(pk.getFieldsArray())));
                    break;
                }
                super.accept(ctx);
                break;
            }
        }
    }
}

