/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

final class Contains<T>
extends AbstractCondition {
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private final Field<T> lhs;
    private final Field<T> rhs;
    private final T value;
    private final boolean leftWildcard;
    private final boolean rightWildcard;

    Contains(Field<T> field, T value, boolean leftWildcard, boolean rightWildcard) {
        this.lhs = field;
        this.rhs = null;
        this.value = value;
        this.leftWildcard = leftWildcard;
        this.rightWildcard = rightWildcard;
    }

    Contains(Field<T> field, Field<T> rhs, boolean leftWildcard, boolean rightWildcard) {
        this.lhs = field;
        this.rhs = rhs;
        this.value = null;
        this.leftWildcard = leftWildcard;
        this.rightWildcard = rightWildcard;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.lhs.getDataType().isArray() || this.rhs != null && this.rhs.getDataType().isArray() || this.rhs == null && this.value != null && this.value.getClass().isArray()) {
            ctx.visit(new PostgresArrayContains());
        } else {
            switch (ctx.family()) {
                default: 
            }
            Field[] array = new Field[1 + (this.leftWildcard ? 1 : 0) + (this.rightWildcard ? 1 : 0)];
            int i = 0;
            if (this.leftWildcard) {
                array[i++] = DSL.inline("%");
            }
            array[i++] = Tools.escapeForLike(this.rhs == null ? Tools.field(this.value, this.lhs) : this.rhs, ctx.configuration());
            if (this.rightWildcard) {
                array[i++] = DSL.inline("%");
            }
            ctx.visit(this.lhs.like(DSL.concat(array), '!'));
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private class PostgresArrayContains
    extends AbstractCondition {
        private PostgresArrayContains() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Contains.this.lhs).sql(" @> ").visit(this.rhs());
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return CLAUSES;
        }

        private final Field<T> rhs() {
            return Contains.this.rhs == null ? DSL.val(Contains.this.value, Contains.this.lhs) : Contains.this.rhs;
        }
    }
}

