/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Comment;
import org.jooq.CommentOnFinalStep;
import org.jooq.CommentOnIsStep;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class CommentOnImpl
extends AbstractDDLQuery
implements CommentOnIsStep,
CommentOnFinalStep {
    private final Table<?> table;
    private final boolean isView;
    private final Field<?> field;
    private Comment comment;
    private static final Set<SQLDialect> SUPPORTS_COMMENT_ON_VIEW = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES);

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, Field<?> field) {
        this(configuration, table, isView, field, null);
    }

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView) {
        this(configuration, table, isView, null);
    }

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView, Field<?> field, Comment comment) {
        super(configuration);
        this.table = table;
        this.isView = isView;
        this.field = field;
        this.comment = comment;
    }

    final Table<?> $table() {
        return this.table;
    }

    final boolean $isView() {
        return this.isView;
    }

    final Field<?> $field() {
        return this.field;
    }

    final Comment $comment() {
        return this.comment;
    }

    @Override
    public final CommentOnImpl is(String comment) {
        return this.is(DSL.comment(comment));
    }

    @Override
    public final CommentOnImpl is(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.table != null) {
                    this.acceptMySQL(ctx);
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptMySQL(Context<?> ctx) {
        ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.table).sql(' ').visit(Keywords.K_COMMENT).sql(" = ").visit(this.comment);
    }

    private final void acceptDefault(Context<?> ctx) {
        ctx.visit(Keywords.K_COMMENT).sql(' ').visit(Keywords.K_ON).sql(' ');
        if (this.table != null) {
            ctx.visit(this.isView && SUPPORTS_COMMENT_ON_VIEW.contains((Object)ctx.dialect()) ? Keywords.K_VIEW : Keywords.K_TABLE).sql(' ').visit(this.table);
        } else if (this.field != null) {
            ctx.visit(Keywords.K_COLUMN).sql(' ').visit(this.field);
        } else {
            throw new IllegalStateException();
        }
        ctx.sql(' ').visit(Keywords.K_IS).sql(' ').visit(this.comment);
    }
}

