/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.AlterSequenceFinalStep;
import org.jooq.AlterSequenceFlagsStep;
import org.jooq.AlterSequenceStep;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Sequence;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class AlterSequenceImpl<T extends Number>
extends AbstractDDLQuery
implements AlterSequenceStep<T>,
AlterSequenceFlagsStep<T>,
AlterSequenceFinalStep {
    private final Sequence<T> sequence;
    private final boolean alterSequenceIfExists;
    private Sequence<?> renameTo;
    private boolean restart;
    private Field<T> restartWith;
    private Field<T> startWith;
    private Field<T> incrementBy;
    private Field<T> minvalue;
    private boolean noMinvalue;
    private Field<T> maxvalue;
    private boolean noMaxvalue;
    private Boolean cycle;
    private Field<T> cache;
    private boolean noCache;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_SEQUENCE};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SEPARATOR = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.MARIADB);
    private static final Set<SQLDialect> NO_SUPPORT_CACHE = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
    private static final Set<SQLDialect> EMULATE_NO_CACHE = SQLDialect.supportedBy(SQLDialect.POSTGRES);

    AlterSequenceImpl(Configuration configuration, Sequence<T> sequence, boolean alterSequenceIfExists) {
        this(configuration, sequence, alterSequenceIfExists, null, false, null, null, null, null, false, null, false, null, null, false);
    }

    AlterSequenceImpl(Configuration configuration, Sequence<T> sequence, boolean alterSequenceIfExists, Sequence<?> renameTo, boolean restart, Field<T> restartWith, Field<T> startWith, Field<T> incrementBy, Field<T> minvalue, boolean noMinvalue, Field<T> maxvalue, boolean noMaxvalue, Boolean cycle, Field<T> cache, boolean noCache) {
        super(configuration);
        this.sequence = sequence;
        this.alterSequenceIfExists = alterSequenceIfExists;
        this.renameTo = renameTo;
        this.restart = restart;
        this.restartWith = restartWith;
        this.startWith = startWith;
        this.incrementBy = incrementBy;
        this.minvalue = minvalue;
        this.noMinvalue = noMinvalue;
        this.maxvalue = maxvalue;
        this.noMaxvalue = noMaxvalue;
        this.cycle = cycle;
        this.cache = cache;
        this.noCache = noCache;
    }

    final Sequence<T> $sequence() {
        return this.sequence;
    }

    final boolean $alterSequenceIfExists() {
        return this.alterSequenceIfExists;
    }

    final Sequence<?> $renameTo() {
        return this.renameTo;
    }

    final boolean $restart() {
        return this.restart;
    }

    final Field<T> $restartWith() {
        return this.restartWith;
    }

    final Field<T> $startWith() {
        return this.startWith;
    }

    final Field<T> $incrementBy() {
        return this.incrementBy;
    }

    final Field<T> $minvalue() {
        return this.minvalue;
    }

    final boolean $noMinvalue() {
        return this.noMinvalue;
    }

    final Field<T> $maxvalue() {
        return this.maxvalue;
    }

    final boolean $noMaxvalue() {
        return this.noMaxvalue;
    }

    final Boolean $cycle() {
        return this.cycle;
    }

    final Field<T> $cache() {
        return this.cache;
    }

    final boolean $noCache() {
        return this.noCache;
    }

    @Override
    public final AlterSequenceImpl<T> renameTo(String renameTo) {
        return this.renameTo((Sequence)DSL.sequence(DSL.name(renameTo)));
    }

    @Override
    public final AlterSequenceImpl<T> renameTo(Name renameTo) {
        return this.renameTo((Sequence)DSL.sequence(renameTo));
    }

    @Override
    public final AlterSequenceImpl<T> renameTo(Sequence<?> renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> restart() {
        this.restart = true;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> restartWith(T restartWith) {
        return this.restartWith((Field)Tools.field(restartWith));
    }

    @Override
    public final AlterSequenceImpl<T> restartWith(Field<T> restartWith) {
        this.restartWith = restartWith;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> startWith(T startWith) {
        return this.startWith((Field)Tools.field(startWith));
    }

    @Override
    public final AlterSequenceImpl<T> startWith(Field<T> startWith) {
        this.startWith = startWith;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> incrementBy(T incrementBy) {
        return this.incrementBy((Field)Tools.field(incrementBy));
    }

    @Override
    public final AlterSequenceImpl<T> incrementBy(Field<T> incrementBy) {
        this.incrementBy = incrementBy;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> minvalue(T minvalue) {
        return this.minvalue((Field)Tools.field(minvalue));
    }

    @Override
    public final AlterSequenceImpl<T> minvalue(Field<T> minvalue) {
        this.minvalue = minvalue;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> noMinvalue() {
        this.noMinvalue = true;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> maxvalue(T maxvalue) {
        return this.maxvalue((Field)Tools.field(maxvalue));
    }

    @Override
    public final AlterSequenceImpl<T> maxvalue(Field<T> maxvalue) {
        this.maxvalue = maxvalue;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> noMaxvalue() {
        this.noMaxvalue = true;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> cycle() {
        this.cycle = true;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> noCycle() {
        this.cycle = false;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> cache(T cache) {
        return this.cache((Field)Tools.field(cache));
    }

    @Override
    public final AlterSequenceImpl<T> cache(Field<T> cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public final AlterSequenceImpl<T> noCache() {
        this.noCache = true;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.alterSequenceIfExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.ALTER_SEQUENCE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: {
                if (this.renameTo != null) {
                    this.acceptRenameTable(ctx);
                    break;
                }
                this.accept1(ctx);
                break;
            }
            default: {
                this.accept1(ctx);
            }
        }
    }

    private final void acceptRenameTable(Context<?> ctx) {
        boolean qualify = ctx.qualify();
        ctx.start(Clause.ALTER_SEQUENCE_SEQUENCE).start(Clause.ALTER_SEQUENCE_RENAME).visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.sequence).sql(' ').visit(Keywords.K_RENAME_TO).sql(' ').qualify(false, c -> c.visit(this.renameTo)).end(Clause.ALTER_SEQUENCE_RENAME).end(Clause.ALTER_SEQUENCE_SEQUENCE);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.ALTER_SEQUENCE_SEQUENCE).visit(Keywords.K_ALTER).sql(' ').visit(ctx.family() == SQLDialect.CUBRID ? Keywords.K_SERIAL : Keywords.K_SEQUENCE);
        if (this.alterSequenceIfExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        switch (ctx.family()) {
            default: 
        }
        ctx.sql(' ').visit(this.sequence);
        ctx.end(Clause.ALTER_SEQUENCE_SEQUENCE);
        if (this.renameTo != null) {
            ctx.start(Clause.ALTER_SEQUENCE_RENAME).sql(' ').visit(Keywords.K_RENAME_TO).sql(' ').qualify(false, c -> c.visit(this.renameTo)).end(Clause.ALTER_SEQUENCE_RENAME);
        } else {
            String noSeparator;
            ctx.start(Clause.ALTER_SEQUENCE_RESTART);
            String string = noSeparator = NO_SEPARATOR.contains((Object)ctx.dialect()) ? "" : " ";
            if (this.incrementBy != null) {
                ctx.sql(' ').visit(Keywords.K_INCREMENT_BY).sql(' ').visit(this.incrementBy);
            }
            if (this.minvalue != null) {
                ctx.sql(' ').visit(Keywords.K_MINVALUE).sql(' ').visit(this.minvalue);
            } else if (this.noMinvalue) {
                ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_MINVALUE);
            }
            if (this.maxvalue != null) {
                ctx.sql(' ').visit(Keywords.K_MAXVALUE).sql(' ').visit(this.maxvalue);
            } else if (this.noMaxvalue) {
                ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_MAXVALUE);
            }
            if (this.startWith != null) {
                ctx.sql(' ').visit(Keywords.K_START_WITH).sql(' ').visit(this.startWith);
            }
            if (this.restart) {
                ctx.sql(' ').visit(Keywords.K_RESTART);
            } else if (this.restartWith != null) {
                if (ctx.family() == SQLDialect.CUBRID) {
                    ctx.sql(' ').visit(Keywords.K_START_WITH).sql(' ').visit(this.restartWith);
                } else {
                    ctx.sql(' ').visit(Keywords.K_RESTART_WITH).sql(' ').visit(this.restartWith);
                }
            }
            if (!NO_SUPPORT_CACHE.contains((Object)ctx.dialect())) {
                if (this.cache != null) {
                    ctx.sql(' ').visit(Keywords.K_CACHE).sql(' ').visit(this.cache);
                } else if (this.noCache) {
                    if (EMULATE_NO_CACHE.contains((Object)ctx.dialect())) {
                        ctx.sql(' ').visit(Keywords.K_CACHE).sql(' ').sql(1);
                    } else {
                        ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_CACHE);
                    }
                }
            }
            if (Boolean.TRUE.equals(this.cycle)) {
                ctx.sql(' ').visit(Keywords.K_CYCLE);
            } else if (Boolean.FALSE.equals(this.cycle)) {
                ctx.sql(' ').visit(Keywords.K_NO).sql(noSeparator).visit(Keywords.K_CYCLE);
            }
            ctx.end(Clause.ALTER_SEQUENCE_RESTART);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

