/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.AlterSchemaFinalStep;
import org.jooq.AlterSchemaStep;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.Schema;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class AlterSchemaImpl
extends AbstractDDLQuery
implements AlterSchemaStep,
AlterSchemaFinalStep {
    private final Schema schema;
    private final boolean alterSchemaIfExists;
    private Schema renameTo;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_SCHEMA};

    AlterSchemaImpl(Configuration configuration, Schema schema, boolean alterSchemaIfExists) {
        this(configuration, schema, alterSchemaIfExists, null);
    }

    AlterSchemaImpl(Configuration configuration, Schema schema, boolean alterSchemaIfExists, Schema renameTo) {
        super(configuration);
        this.schema = schema;
        this.alterSchemaIfExists = alterSchemaIfExists;
        this.renameTo = renameTo;
    }

    final Schema $schema() {
        return this.schema;
    }

    final boolean $alterSchemaIfExists() {
        return this.alterSchemaIfExists;
    }

    final Schema $renameTo() {
        return this.renameTo;
    }

    @Override
    public final AlterSchemaImpl renameTo(String renameTo) {
        return this.renameTo(DSL.schema(DSL.name(renameTo)));
    }

    @Override
    public final AlterSchemaImpl renameTo(Name renameTo) {
        return this.renameTo(DSL.schema(renameTo));
    }

    @Override
    public final AlterSchemaImpl renameTo(Schema renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.accept0(ctx);
    }

    private final void accept0(Context<?> ctx) {
        ctx.start(Clause.ALTER_SCHEMA_SCHEMA);
        boolean supportRename = false;
        if (supportRename) {
            ctx.visit(Keywords.K_RENAME).sql(' ').visit(Keywords.K_SCHEMA);
        } else {
            ctx.visit(Keywords.K_ALTER_SCHEMA);
        }
        if (this.alterSchemaIfExists) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.schema).end(Clause.ALTER_SCHEMA_SCHEMA).formatIndentStart().formatSeparator();
        if (this.renameTo != null) {
            ctx.start(Clause.ALTER_SCHEMA_RENAME).visit(supportRename ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').qualify(false, c -> c.visit(this.renameTo)).end(Clause.ALTER_SCHEMA_RENAME);
        }
        ctx.formatIndentEnd();
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

