/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Binding;
import org.jooq.CharacterSet;
import org.jooq.Collation;
import org.jooq.Configuration;
import org.jooq.Converter;
import org.jooq.Converters;
import org.jooq.Domain;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.Named;
import org.jooq.Nullability;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Support;

public interface DataType<T>
extends Named {
    @Nullable
    public DataType<T> getSQLDataType();

    @NotNull
    public DataType<T> getDataType(Configuration var1);

    public int getSQLType();

    public int getSQLType(Configuration var1);

    @NotNull
    public Binding<?, T> getBinding();

    @NotNull
    public Converter<?, T> getConverter();

    @NotNull
    public Class<T> getType();

    @Nullable
    public Domain<T> getDomain();

    @Nullable
    public Row getRow();

    @Nullable
    public Class<? extends Record> getRecordType();

    @NotNull
    public Class<T[]> getArrayType();

    @NotNull
    public DataType<T[]> getArrayDataType();

    @Nullable
    public Class<?> getArrayComponentType();

    @Nullable
    public DataType<?> getArrayComponentDataType();

    @NotNull
    public <E extends EnumType> DataType<E> asEnumDataType(Class<E> var1);

    @NotNull
    public <U> DataType<U> asConvertedDataType(Converter<? super T, U> var1);

    @NotNull
    default public <U> DataType<U> asConvertedDataType(Class<U> toType, Function<? super T, ? extends U> from, Function<? super U, ? extends T> to) {
        return this.asConvertedDataType(Converter.of(this.getType(), toType, from, to));
    }

    @NotNull
    default public <U> DataType<U> asConvertedDataTypeFrom(Class<U> toType, Function<? super T, ? extends U> from) {
        return this.asConvertedDataType(Converter.from(this.getType(), toType, from));
    }

    @NotNull
    default public <U> DataType<U> asConvertedDataTypeFrom(Function<? super T, ? extends U> from) {
        return this.asConvertedDataType(Converter.from(this.getType(), Converters.UnknownType.class, from));
    }

    @NotNull
    default public <U> DataType<U> asConvertedDataTypeTo(Class<U> toType, Function<? super U, ? extends T> to) {
        return this.asConvertedDataType(Converter.to(this.getType(), toType, to));
    }

    @NotNull
    default public <U> DataType<U> asConvertedDataTypeTo(Function<? super U, ? extends T> to) {
        return this.asConvertedDataType(Converter.to(this.getType(), Converters.UnknownType.class, to));
    }

    @NotNull
    public <U> DataType<U> asConvertedDataType(Binding<? super T, U> var1);

    @NotNull
    public String getTypeName();

    @NotNull
    public String getTypeName(Configuration var1);

    @NotNull
    public String getCastTypeName();

    @NotNull
    public String getCastTypeName(Configuration var1);

    @Nullable
    public SQLDialect getDialect();

    public T convert(Object var1);

    @NotNull
    public T[] convert(Object ... var1);

    @NotNull
    public List<T> convert(Collection<?> var1);

    @Support
    @NotNull
    public DataType<T> nullability(Nullability var1);

    @NotNull
    public Nullability nullability();

    @Support
    @NotNull
    public DataType<T> nullable(boolean var1);

    public boolean nullable();

    @Support
    @NotNull
    public DataType<T> null_();

    @Support
    @NotNull
    public DataType<T> notNull();

    @Support(value={SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE})
    @NotNull
    public DataType<T> collation(Collation var1);

    @Nullable
    public Collation collation();

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public DataType<T> characterSet(CharacterSet var1);

    @Nullable
    public CharacterSet characterSet();

    @Support(value={SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE})
    @NotNull
    public DataType<T> identity(boolean var1);

    public boolean identity();

    @Support
    @NotNull
    public DataType<T> defaultValue(T var1);

    @Support
    @NotNull
    public DataType<T> defaultValue(Field<T> var1);

    @Nullable
    public Field<T> defaultValue();

    @Support
    @NotNull
    public DataType<T> default_(T var1);

    @Support
    @NotNull
    public DataType<T> default_(Field<T> var1);

    @Nullable
    public Field<T> default_();

    @Deprecated(forRemoval=true, since="3.8")
    @NotNull
    public DataType<T> defaulted(boolean var1);

    public boolean defaulted();

    @Support
    @NotNull
    public DataType<T> precision(int var1);

    @Support
    @NotNull
    public DataType<T> precision(int var1, int var2);

    public int precision();

    public boolean hasPrecision();

    public boolean precisionDefined();

    @Support
    @NotNull
    public DataType<T> scale(int var1);

    public int scale();

    public boolean hasScale();

    public boolean scaleDefined();

    @Support
    @NotNull
    public DataType<T> length(int var1);

    public int length();

    public boolean hasLength();

    public boolean lengthDefined();

    public boolean isNumeric();

    public boolean isInteger();

    public boolean isString();

    public boolean isNString();

    public boolean isDateTime();

    public boolean isDate();

    public boolean isTimestamp();

    public boolean isTime();

    public boolean isTemporal();

    public boolean isInterval();

    public boolean isBinary();

    public boolean isLob();

    public boolean isArray();

    public boolean isEmbeddable();

    public boolean isUDT();

    public boolean isRecord();

    public boolean isMultiset();

    public boolean isEnum();

    public boolean isJSON();

    public boolean isXML();
}

