/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.Reflection;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jooby.Deferred;
import org.jooby.Err;
import org.jooby.Jooby;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Result;
import org.jooby.Results;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.funzy.Try;

public class MockRouter {
    private static final Route.Chain NOOP_CHAIN = new Route.Chain(){

        @Override
        public List<Route> routes() {
            return ImmutableList.of();
        }

        @Override
        public void next(String prefix, Request req, Response rsp) throws Throwable {
        }
    };
    private static final int CLEAN_STACK = 4;
    private Map<Key, Object> registry = new HashMap<Key, Object>();
    private List<Route.Definition> routes;
    private Request req;
    private Response rsp;

    public MockRouter(Jooby app) {
        this(app, MockRouter.empty(Request.class), MockRouter.empty(Response.class));
    }

    public MockRouter(Jooby app, Request req) {
        this(app, req, MockRouter.empty(Response.class));
    }

    public MockRouter(Jooby app, Request req, Response rsp) {
        this.routes = Jooby.exportRoutes(this.hackInjector(app));
        this.req = req;
        this.rsp = rsp;
    }

    public MockRouter set(Object dependency) {
        return this.set(null, dependency);
    }

    public MockRouter set(String name, Object object) {
        this.traverse(object.getClass(), type -> {
            Object key = Optional.ofNullable(name).map(it -> Key.get(type, (Annotation)Names.named(name))).orElseGet(() -> Key.get(type));
            this.registry.putIfAbsent((Key)key, object);
        });
        return this;
    }

    public <T> T get(String path) throws Throwable {
        return this.execute("GET", path);
    }

    public <T> T post(String path) throws Throwable {
        return this.execute("POST", path);
    }

    public <T> T put(String path) throws Throwable {
        return this.execute("PUT", path);
    }

    public <T> T patch(String path) throws Throwable {
        return this.execute("PATCH", path);
    }

    public <T> T delete(String path) throws Throwable {
        return this.execute("DELETE", path);
    }

    public <T> T execute(String method, String path) throws Throwable {
        return this.execute(method, path, MediaType.all, MediaType.all);
    }

    private <T> T execute(String method, String path, MediaType contentType, MediaType ... accept) throws Throwable {
        List<Route.Filter> filters = this.pipeline(method, path, contentType, Arrays.asList(accept));
        if (filters.isEmpty()) {
            throw new Err(Status.NOT_FOUND, path);
        }
        Iterator<Route.Filter> pipeline = filters.iterator();
        AtomicReference<Object> ref = new AtomicReference<Object>();
        MockResponse rsp = new MockResponse(this.rsp, ref);
        while (ref.get() == null && pipeline.hasNext()) {
            Route.Filter next = pipeline.next();
            if (next instanceof Route.ZeroArgHandler) {
                ref.set(((Route.ZeroArgHandler)next).handle());
                continue;
            }
            if (next instanceof Route.OneArgHandler) {
                ref.set(((Route.OneArgHandler)next).handle(this.req));
                continue;
            }
            if (next instanceof Route.Handler) {
                ((Route.Handler)next).handle(this.req, rsp);
                continue;
            }
            next.handle(this.req, rsp, NOOP_CHAIN);
        }
        Object lastResult = ref.get();
        if (rsp.afterList.size() > 0) {
            Result result = this.wrap(lastResult);
            for (int i = rsp.afterList.size() - 1; i >= 0; --i) {
                result = rsp.afterList.get(i).handle(this.req, (Response)rsp, result);
            }
            if (Result.class.isInstance(lastResult)) {
                return (T)result;
            }
            return result.get();
        }
        if (lastResult instanceof Deferred) {
            Deferred deferred = (Deferred)lastResult;
            deferred.handler(this.req, (v, x) -> {});
            lastResult = deferred.get();
            if (Throwable.class.isInstance(lastResult)) {
                throw (Throwable)lastResult;
            }
        }
        return (T)lastResult;
    }

    private Result wrap(Object value) {
        if (value instanceof Result) {
            return (Result)value;
        }
        return Results.with(value);
    }

    private List<Route.Filter> pipeline(String method, String path, MediaType contentType, List<MediaType> accept) {
        ArrayList<Route.Filter> routes = new ArrayList<Route.Filter>();
        for (Route.Definition routeDef : this.routes) {
            Optional<Route> route = routeDef.matches(method, path, contentType, accept);
            if (!route.isPresent()) continue;
            routes.add(routeDef.filter());
        }
        return routes;
    }

    private Jooby hackInjector(Jooby app) {
        Try.run(() -> {
            Field field = Jooby.class.getDeclaredField("injector");
            field.setAccessible(true);
            Injector injector = MockRouter.proxyInjector(this.getClass().getClassLoader(), this.registry);
            field.set(app, injector);
            this.registry.put(Key.get(Injector.class), injector);
        }).throwException();
        return app;
    }

    private static Injector proxyInjector(ClassLoader loader, Map<Key, Object> registry) {
        return Reflection.newProxy(Injector.class, (proxy, method, args) -> {
            if (method.getName().equals("getInstance")) {
                Key key = (Key)args[0];
                Object value = registry.get(key);
                if (value == null) {
                    Object type = key.getAnnotation() != null ? key : key.getTypeLiteral();
                    IllegalStateException iex = new IllegalStateException("Not found: " + type);
                    Try.apply(() -> {
                        StackTraceElement[] stacktrace = iex.getStackTrace();
                        return Lists.newArrayList(stacktrace).subList(4, stacktrace.length);
                    }).onSuccess(stacktrace -> iex.setStackTrace(stacktrace.toArray(new StackTraceElement[stacktrace.size()])));
                    throw iex;
                }
                return value;
            }
            throw new UnsupportedOperationException(method.toString());
        });
    }

    private void traverse(Class type, Consumer<Class> set) {
        if (type != Object.class) {
            set.accept(type);
            Optional.ofNullable(type.getSuperclass()).ifPresent(it -> this.traverse((Class)it, set));
            Arrays.asList(type.getInterfaces()).forEach(it -> this.traverse((Class)it, set));
        }
    }

    private static <T> T empty(Class<T> type) {
        return Reflection.newProxy(type, (proxy, method, args) -> {
            throw new UnsupportedOperationException(method.toString());
        });
    }

    private static class MockResponse
    extends Response.Forwarding {
        List<Route.After> afterList = new ArrayList<Route.After>();
        private AtomicReference<Object> ref;

        public MockResponse(Response response, AtomicReference<Object> ref) {
            super(response);
            this.ref = ref;
        }

        @Override
        public void after(Route.After handler) {
            this.afterList.add(handler);
        }

        @Override
        public void send(Object result) throws Throwable {
            this.rsp.send(result);
            this.ref.set(result);
        }

        @Override
        public void send(Result result) throws Throwable {
            this.rsp.send(result);
            this.ref.set(result);
        }
    }
}

