/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.ssl;

import java.io.File;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;
import org.jooby.internal.ssl.JdkSslContext;

public final class JdkSslServerContext
extends JdkSslContext {
    private final SSLContext ctx;

    public JdkSslServerContext(File trustCertChainFile, File keyCertChainFile, File keyFile, String keyPassword, long sessionCacheSize, long sessionTimeout) throws SSLException {
        try {
            TrustManagerFactory trustManagerFactory = null;
            if (trustCertChainFile != null) {
                trustManagerFactory = JdkSslServerContext.buildTrustManagerFactory(trustCertChainFile, trustManagerFactory);
            }
            KeyManagerFactory keyManagerFactory = JdkSslServerContext.buildKeyManagerFactory(keyCertChainFile, keyFile, keyPassword);
            this.ctx = SSLContext.getInstance("TLS");
            this.ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers(), null);
            SSLSessionContext sessCtx = this.ctx.getServerSessionContext();
            if (sessionCacheSize > 0L) {
                sessCtx.setSessionCacheSize((int)Math.min(sessionCacheSize, Integer.MAX_VALUE));
            }
            if (sessionTimeout > 0L) {
                sessCtx.setSessionTimeout((int)Math.min(sessionTimeout, Integer.MAX_VALUE));
            }
        }
        catch (Exception e) {
            throw new SSLException("failed to initialize the server-side SSL context", e);
        }
    }

    @Override
    public SSLContext context() {
        return this.ctx;
    }
}

