/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser.bean;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jooby.internal.parser.bean.BeanPath;

class BeanMethodPath
implements BeanPath {
    private String path;
    private Method method;
    BeanPath setter;

    public BeanMethodPath(String path, Method method) {
        this.path = path;
        this.method = method;
        this.method.setAccessible(true);
    }

    @Override
    public void set(Object bean, Object ... args) throws Throwable {
        if (this.setter != null) {
            this.setter.set(bean, args);
        } else {
            this.method.invoke(bean, args);
        }
    }

    @Override
    public Object get(Object bean, Object ... args) throws Throwable {
        return this.method.invoke(bean, args);
    }

    @Override
    public Type settype() {
        if (this.method.getParameterCount() == 0) {
            return this.method.getGenericReturnType();
        }
        return this.method.getGenericParameterTypes()[0];
    }

    @Override
    public Type type() {
        return this.method.getGenericReturnType();
    }

    @Override
    public AnnotatedElement setelem() {
        return this.method;
    }

    public String toString() {
        return this.path;
    }
}

