/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser.bean;

import com.google.inject.TypeLiteral;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.jooby.internal.parser.bean.BeanPath;

class BeanIndexedPath
implements BeanPath {
    private int index;
    private BeanPath path;
    private Type type;

    public BeanIndexedPath(@Nullable BeanPath path, int index, TypeLiteral ittype) {
        this(path, index, path == null ? ittype.getType() : path.type());
    }

    public BeanIndexedPath(BeanPath path, int index, Type ittype) {
        this.path = path;
        this.index = index;
        this.type = ((ParameterizedType)ittype).getActualTypeArguments()[0];
    }

    @Override
    public void set(Object bean, Object ... args) throws Throwable {
        List list = this.list(bean);
        list.add(args[0]);
    }

    @Override
    public Object get(Object bean, Object ... args) throws Throwable {
        List list = this.list(bean);
        if (this.index >= list.size()) {
            Object item = ((Class)this.settype()).newInstance();
            list.add(item);
        }
        return list.get(this.index);
    }

    private List list(Object bean) throws Throwable {
        ArrayList list = (ArrayList)(this.path == null ? bean : this.path.get(bean, new Object[0]));
        if (list == null) {
            list = new ArrayList();
            this.path.set(bean, list);
        }
        return list;
    }

    @Override
    public AnnotatedElement setelem() {
        return this.path.setelem();
    }

    @Override
    public Type settype() {
        return this.type;
    }

    @Override
    public Type type() {
        return this.type;
    }

    public String toString() {
        return (this.path == null ? "" : this.path.toString()) + "[" + this.index + "]";
    }
}

