/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.jooby.Parser;

public class StringConstructorParser
implements Parser {
    public boolean matches(TypeLiteral<?> toType) {
        try {
            return StringConstructorParser.constructor(toType.getRawType()) != null;
        }
        catch (NoSuchMethodException x) {
            return false;
        }
    }

    @Override
    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Exception {
        return ctx.param(params -> {
            try {
                return StringConstructorParser.constructor(type.getRawType()).newInstance(params.get(0));
            }
            catch (NoSuchMethodException x) {
                return ctx.next();
            }
        });
    }

    public String toString() {
        return "init(String)";
    }

    public static Object parse(TypeLiteral<?> type, Object data) throws Exception {
        return StringConstructorParser.constructor(type.getRawType()).newInstance(data);
    }

    private static Constructor<?> constructor(Class<?> rawType) throws NoSuchMethodException {
        Constructor<?> constructor = rawType.getDeclaredConstructor(String.class);
        return Modifier.isPublic(constructor.getModifiers()) ? constructor : null;
    }
}

