/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.mvc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooby.Cookie;
import org.jooby.Err;
import org.jooby.Mutant;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.Status;
import org.jooby.Upload;
import org.jooby.mvc.Body;
import org.jooby.mvc.Flash;
import org.jooby.mvc.Header;
import org.jooby.mvc.Local;

public class RequestParam {
    private static final TypeLiteral<Header> headerType = TypeLiteral.get(Header.class);
    private static final TypeLiteral<Body> bodyType = TypeLiteral.get(Body.class);
    private static final TypeLiteral<Local> localType = TypeLiteral.get(Local.class);
    private static final TypeLiteral<Flash> flashType = TypeLiteral.get(Flash.class);
    private static final Map<Object, GetValue> injector;
    public final String name;
    public final TypeLiteral type;
    private final GetValue strategy;
    private boolean optional;

    public RequestParam(Parameter parameter, String name) {
        this(parameter, name, parameter.getParameterizedType());
    }

    public RequestParam(AnnotatedElement elem, String name, Type type) {
        this.name = name;
        this.type = TypeLiteral.get(type);
        boolean bl = this.optional = this.type.getRawType() == Optional.class;
        TypeLiteral<Annotation> strategyType = elem.getAnnotation(Header.class) != null ? headerType : (elem.getAnnotation(Body.class) != null ? bodyType : (elem.getAnnotation(Local.class) != null ? localType : (elem.getAnnotation(Flash.class) != null ? flashType : this.type)));
        this.strategy = injector.getOrDefault(strategyType, RequestParam.param());
    }

    public Object value(Request req, Response rsp, Route.Chain chain) throws Throwable {
        return this.strategy.apply(req, rsp, chain, this);
    }

    public static String nameFor(Parameter param) {
        String name = RequestParam.findName(param);
        return name == null ? (param.isNamePresent() ? param.getName() : null) : name;
    }

    private static String findName(AnnotatedElement elem) {
        javax.inject.Named named = elem.getAnnotation(javax.inject.Named.class);
        if (named == null) {
            Named gnamed = elem.getAnnotation(Named.class);
            if (gnamed == null) {
                Header header = elem.getAnnotation(Header.class);
                if (header == null) {
                    return null;
                }
                return Strings.emptyToNull(header.value());
            }
            return gnamed.value();
        }
        return Strings.emptyToNull(named.value());
    }

    private static final GetValue param() {
        return (req, rsp, chain, param) -> {
            Mutant mutant = req.param(param.name);
            if (mutant.isSet() || param.optional) {
                return mutant.to(param.type);
            }
            try {
                return req.params().to(param.type);
            }
            catch (Err ex) {
                return mutant.to(param.type);
            }
        };
    }

    static {
        ImmutableMap.Builder<TypeLiteral<?>, GetValue> builder = ImmutableMap.builder();
        builder.put(bodyType, (req, rsp, chain, param) -> req.body().to(param.type));
        builder.put(TypeLiteral.get(Request.class), (req, rsp, chain, param) -> req);
        builder.put(TypeLiteral.get(Route.class), (req, rsp, chain, param) -> req.route());
        builder.put(TypeLiteral.get(Response.class), (req, rsp, chain, param) -> rsp);
        builder.put(TypeLiteral.get(Route.Chain.class), (req, rsp, chain, param) -> chain);
        builder.put(TypeLiteral.get(Session.class), (req, rsp, chain, param) -> req.session());
        builder.put(TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Session.class})), (req, rsp, chain, param) -> req.ifSession());
        builder.put(TypeLiteral.get(Upload.class), (req, rsp, chain, param) -> req.file(param.name));
        builder.put(TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Upload.class})), (req, rsp, chain, param) -> {
            List<Upload> files = req.files(param.name);
            return files.size() == 0 ? Optional.empty() : Optional.of(files.get(0));
        });
        builder.put(TypeLiteral.get(Types.newParameterizedType(List.class, new Type[]{Upload.class})), (req, rsp, chain, param) -> req.files(param.name));
        builder.put(TypeLiteral.get(Cookie.class), (req, rsp, chain, param) -> req.cookies().stream().filter(c -> c.name().equalsIgnoreCase(param.name)).findFirst().get());
        builder.put(TypeLiteral.get(Types.listOf(Cookie.class)), (req, rsp, chain, param) -> req.cookies());
        builder.put(TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Cookie.class})), (req, rsp, chain, param) -> req.cookies().stream().filter(c -> c.name().equalsIgnoreCase(param.name)).findFirst());
        builder.put(headerType, (req, rsp, chain, param) -> req.header(param.name).to(param.type));
        builder.put(localType, (req, rsp, chain, param) -> {
            Optional local = req.ifGet(param.name);
            if (param.optional) {
                return local;
            }
            if (local.isPresent()) {
                return local.get();
            }
            if (param.type.getRawType() == Map.class) {
                return req.attributes();
            }
            throw new Err(Status.SERVER_ERROR, "Could not find required local '" + param.name + "', which was required on " + req.path());
        });
        builder.put(flashType, (req, rsp, chain, param) -> {
            Class rawType = param.type.getRawType();
            if (Map.class.isAssignableFrom(rawType)) {
                return req.flash();
            }
            return param.optional ? req.ifFlash(param.name) : req.flash(param.name);
        });
        injector = builder.build();
    }

    private static interface GetValue {
        public Object apply(Request var1, Response var2, Route.Chain var3, RequestParam var4) throws Exception;
    }
}

