/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.typesafe.config.Config;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.jooby.Err;
import org.jooby.Status;

public class StatusCodeProvider {
    private Config conf;

    @Inject
    public StatusCodeProvider(Config conf) {
        this.conf = conf;
    }

    public Status apply(Throwable cause) {
        if (cause instanceof Err) {
            return Status.valueOf(((Err)cause).statusCode());
        }
        Function<Class, String> name = type -> Optional.ofNullable(type.getDeclaringClass()).map(dc -> dc.getName() + '.' + type.getSimpleName()).orElse(type.getName());
        Config err = this.conf.getConfig("err");
        int status = -1;
        Class<?> type2 = cause.getClass();
        while (type2 != Throwable.class && status == -1) {
            String classname = name.apply(type2);
            if (err.hasPath(classname)) {
                status = err.getInt(classname);
                continue;
            }
            type2 = type2.getSuperclass();
        }
        return status == -1 ? Status.SERVER_ERROR : Status.valueOf(status);
    }
}

