/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jooby.internal.RegexRouteMatcher;
import org.jooby.internal.RouteMatcher;
import org.jooby.internal.SimpleRouteMatcher;
import org.jooby.internal.SimpleRouteMatcherNoCase;

public class RoutePattern {
    private static final Pattern GLOB = Pattern.compile("\\?|/\\*\\*(\\:(?:[^/]+))?|\\*|\\:((?:[^/]+)+?)|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
    private static final Pattern SLASH = Pattern.compile("//+");
    private final Function<String, RouteMatcher> matcher;
    private String pattern;
    private List<String> vars;
    private List<String> reverse;
    private boolean glob;

    public RoutePattern(String verb, String pattern) {
        this(verb, pattern, false);
    }

    public RoutePattern(String verb, String pattern, boolean ignoreCase) {
        Objects.requireNonNull(verb, "A HTTP verb is required.");
        Objects.requireNonNull(pattern, "A path pattern is required.");
        this.pattern = RoutePattern.normalize(pattern);
        Rewrite rewrite = RoutePattern.rewrite(this, verb.toUpperCase(), this.pattern.replace("/**/", "/**"), ignoreCase);
        this.matcher = rewrite.fn;
        this.vars = rewrite.vars;
        this.reverse = rewrite.reverse;
        this.glob = rewrite.glob;
    }

    public boolean glob() {
        return this.glob;
    }

    public List<String> vars() {
        return this.vars;
    }

    public String pattern() {
        return this.pattern;
    }

    public String reverse(Map<String, Object> vars) {
        return this.reverse.stream().map(segment -> vars.getOrDefault(segment, segment).toString()).collect(Collectors.joining(""));
    }

    public String reverse(Object ... value) {
        List<String> vars = this.vars();
        HashMap<String, Object> hash = new HashMap<String, Object>();
        for (int i = 0; i < Math.min(vars.size(), value.length); ++i) {
            hash.put(vars.get(i), value[i]);
        }
        return this.reverse(hash);
    }

    public RouteMatcher matcher(String path) {
        Objects.requireNonNull(path, "A path is required.");
        return this.matcher.apply(path);
    }

    private static Rewrite rewrite(RoutePattern owner, String verb, String pattern, boolean ignoreCase) {
        LinkedList<String> vars = new LinkedList<String>();
        String rwrverb = RoutePattern.verbs(verb);
        StringBuilder patternBuilder = new StringBuilder(rwrverb);
        Matcher matcher = GLOB.matcher(pattern);
        int end = 0;
        boolean regex = !rwrverb.equals(verb);
        ArrayList<String> reverse = new ArrayList<String>();
        boolean glob = false;
        while (matcher.find()) {
            String head = pattern.substring(end, matcher.start());
            patternBuilder.append(Pattern.quote(head));
            reverse.add(head);
            String match = matcher.group();
            if ("?".equals(match)) {
                patternBuilder.append("([^/])");
                reverse.add(match);
                regex = true;
                glob = true;
            } else if ("*".equals(match)) {
                patternBuilder.append("([^/]*)");
                reverse.add(match);
                regex = true;
                glob = true;
            } else if (match.equals("/**")) {
                reverse.add(match);
                patternBuilder.append("($|/.*)");
                regex = true;
                glob = true;
            } else if (match.startsWith("/**:")) {
                reverse.add(match.substring(1));
                String varName = match.substring(4);
                patternBuilder.append("/(?<v").append(vars.size()).append(">($|.*))");
                vars.add(varName);
                regex = true;
                glob = true;
            } else if (match.startsWith(":")) {
                regex = true;
                String varName = match.substring(1);
                patternBuilder.append("(?<v").append(vars.size()).append(">[^/]+)");
                vars.add(varName);
                reverse.add(varName);
            } else if (match.startsWith("{") && match.endsWith("}")) {
                String varName;
                regex = true;
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    varName = match.substring(1, match.length() - 1);
                    patternBuilder.append("(?<v").append(vars.size()).append(">[^/]+)");
                    vars.add(varName);
                    reverse.add(varName);
                } else {
                    varName = match.substring(1, colonIdx);
                    String regexpr = match.substring(colonIdx + 1, match.length() - 1);
                    patternBuilder.append("(?<v").append(vars.size()).append(">");
                    patternBuilder.append("**".equals(regexpr) ? "($|.*)" : regexpr);
                    patternBuilder.append(')');
                    vars.add(varName);
                    reverse.add(varName);
                }
            }
            end = matcher.end();
        }
        String tail = pattern.substring(end, pattern.length());
        reverse.add(tail);
        patternBuilder.append(Pattern.quote(tail));
        return new Rewrite(RoutePattern.fn(owner, regex, regex ? patternBuilder.toString() : verb + pattern, vars, ignoreCase), vars, reverse, glob);
    }

    private static String verbs(String verb) {
        String[] verbs = verb.split("\\|");
        if (verbs.length == 1) {
            return verb.equals("*") ? "(?:[^/]*)" : verb;
        }
        return "(?:" + verb + ")";
    }

    private static Function<String, RouteMatcher> fn(RoutePattern owner, final boolean complex, final String pattern, final List<String> vars, final boolean ignoreCase) {
        return new Function<String, RouteMatcher>(){
            final Pattern regex;
            {
                this.regex = complex ? Pattern.compile(pattern, ignoreCase ? 2 : 0) : null;
            }

            @Override
            public RouteMatcher apply(String fullpath) {
                String path = fullpath.substring(Math.max(0, fullpath.indexOf(47)));
                if (complex) {
                    return new RegexRouteMatcher(path, this.regex.matcher(fullpath), vars);
                }
                return ignoreCase ? new SimpleRouteMatcherNoCase(pattern, path, fullpath) : new SimpleRouteMatcher(pattern, path, fullpath);
            }
        };
    }

    public static String normalize(String pattern) {
        if (pattern.equals("*")) {
            return "/**";
        }
        if (pattern.equals("/")) {
            return "/";
        }
        String normalized = SLASH.matcher(pattern).replaceAll("/");
        if (normalized.equals("/")) {
            return "/";
        }
        StringBuilder buffer = new StringBuilder();
        if (!normalized.startsWith("/")) {
            buffer.append("/");
        }
        buffer.append(normalized);
        if (normalized.endsWith("/")) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.pattern;
    }

    private static class Rewrite {
        private final Function<String, RouteMatcher> fn;
        private final List<String> vars;
        private final List<String> reverse;
        private final boolean glob;

        public Rewrite(Function<String, RouteMatcher> fn, List<String> vars, List<String> reverse, boolean glob) {
            this.fn = fn;
            this.vars = vars;
            this.reverse = reverse;
            this.glob = glob;
        }
    }
}

