/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.internal.RequestImpl;
import org.jooby.internal.ResponseImpl;
import org.jooby.internal.RouteWithFilter;

public class RouteChain
implements Route.Chain {
    private Route[] routes;
    private String prefix;
    private int i = 0;
    private RequestImpl rreq;
    private ResponseImpl rrsp;
    private boolean hasAttrs;

    public RouteChain(RequestImpl req, ResponseImpl rsp, Route[] routes) {
        this.routes = routes;
        this.rreq = req;
        this.rrsp = rsp;
        this.hasAttrs = this.hasAttributes(routes);
    }

    private boolean hasAttributes(Route[] routes) {
        for (int i = 0; i < routes.length; ++i) {
            if (routes[i].attributes().size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void next(String prefix, Request req, Response rsp) throws Throwable {
        if (rsp.committed()) {
            return;
        }
        if (prefix != null) {
            this.prefix = prefix;
        }
        Route route = this.next(this.prefix);
        this.rreq.route(this.hasAttrs ? RouteChain.attrs(route, this.routes, this.i - 1) : route);
        this.rrsp.route(route);
        this.get(route).handle(req, rsp, this);
    }

    private Route next(String prefix) {
        Route route = this.routes[this.i++];
        if (prefix == null) {
            return route;
        }
        while (!route.apply(prefix)) {
            route = this.routes[this.i++];
        }
        return route;
    }

    @Override
    public List<Route> routes() {
        return Arrays.asList(this.routes).subList(this.i, this.routes.length - 1);
    }

    private RouteWithFilter get(Route next) {
        return (RouteWithFilter)Route.Forwarding.unwrap(next);
    }

    private static Route attrs(Route route, Route[] routes, int i) {
        final HashMap attrs = new HashMap(16);
        for (int t2 = i; t2 < routes.length; ++t2) {
            routes[t2].attributes().forEach((name, value) -> attrs.putIfAbsent(name, value));
        }
        return new Route.Forwarding(route){

            @Override
            public <T> T attr(String name) {
                return (T)attrs.get(name);
            }

            @Override
            public Map<String, Object> attributes() {
                return attrs;
            }
        };
    }
}

