/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.util.Map;
import org.jooby.Cookie;
import org.jooby.Mutant;
import org.jooby.Response;
import org.jooby.Session;
import org.jooby.internal.SessionImpl;
import org.jooby.internal.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestScopedSession
implements Session {
    private final Logger log = LoggerFactory.getLogger(Session.class);
    private SessionManager sm;
    private Response rsp;
    private SessionImpl session;
    private Runnable resetSession;

    public RequestScopedSession(SessionManager sm, Response rsp, SessionImpl session, Runnable resetSession) {
        this.sm = sm;
        this.rsp = rsp;
        this.session = session;
        this.resetSession = resetSession;
    }

    @Override
    public String id() {
        this.notDestroyed();
        return this.session.id();
    }

    @Override
    public long createdAt() {
        this.notDestroyed();
        return this.session.createdAt();
    }

    @Override
    public long accessedAt() {
        this.notDestroyed();
        return this.session.accessedAt();
    }

    @Override
    public long savedAt() {
        this.notDestroyed();
        return this.session.savedAt();
    }

    @Override
    public long expiryAt() {
        this.notDestroyed();
        return this.session.expiryAt();
    }

    @Override
    public Mutant get(String name) {
        this.notDestroyed();
        return this.session.get(name);
    }

    @Override
    public Map<String, String> attributes() {
        this.notDestroyed();
        return this.session.attributes();
    }

    @Override
    public Session set(String name, String value) {
        this.notDestroyed();
        this.session.set(name, value);
        return this;
    }

    @Override
    public boolean isSet(String name) {
        this.notDestroyed();
        return this.session.isSet(name);
    }

    @Override
    public Mutant unset(String name) {
        this.notDestroyed();
        return this.session.unset(name);
    }

    @Override
    public Session unset() {
        this.notDestroyed();
        this.session.unset();
        return this;
    }

    @Override
    public void destroy() {
        if (this.session != null) {
            this.log.debug("destroying session: {}", (Object)this.session.id());
            this.session.destroy();
            this.resetSession.run();
            Cookie.Definition cookie = this.sm.cookie();
            this.log.debug("  removing cookie: {}", (Object)cookie);
            this.rsp.cookie(cookie.maxAge(0));
            this.sm.destroy(this.session);
            this.resetSession = null;
            this.rsp = null;
            this.session = null;
            this.sm = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        if (this.session == null) {
            return true;
        }
        return this.session.isDestroyed();
    }

    @Override
    public Session renewId() {
        this.sm.renewId(this.session, this.rsp);
        return this;
    }

    public String toString() {
        return this.session.toString();
    }

    public Session session() {
        this.notDestroyed();
        return this.session;
    }

    private void notDestroyed() {
        if (this.isDestroyed()) {
            throw new Session.Destroyed();
        }
    }
}

