/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.jooby.Cookie;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.internal.SessionImpl;
import org.jooby.internal.SessionManager;
import org.jooby.internal.parser.ParserExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieSessionManager
implements SessionManager {
    private final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private final ParserExecutor resolver;
    private Cookie.Definition cookie;
    private long timeout;
    private String secret;

    @Inject
    public CookieSessionManager(ParserExecutor resolver, Session.Definition cookie, @Named(value="application.secret") String secret) {
        this.resolver = resolver;
        this.cookie = cookie.cookie();
        this.timeout = TimeUnit.SECONDS.toMillis(this.cookie.maxAge().get().intValue());
        this.secret = secret;
    }

    @Override
    public Session create(Request req, Response rsp) {
        Session session = new SessionImpl.Builder(this.resolver, true, "cookieSession", -1L).build();
        this.log.debug("session created: {}", (Object)session);
        rsp.after(this.saveCookie());
        return session;
    }

    @Override
    public Session get(Request req, Response rsp) {
        return req.cookie(this.cookie.name().get()).toOptional().map(raw -> {
            SessionImpl.Builder session = new SessionImpl.Builder(this.resolver, false, "cookieSession", -1L);
            Map<String, String> attributes = this.attributes((String)raw);
            session.set(attributes);
            rsp.after(this.saveCookie());
            return session.build();
        }).orElse(null);
    }

    @Override
    public void destroy(Session session) {
    }

    @Override
    public void requestDone(Session session) {
    }

    @Override
    public Cookie.Definition cookie() {
        return new Cookie.Definition(this.cookie);
    }

    @Override
    public void renewId(Session session, Response rsp) {
    }

    private Map<String, String> attributes(String raw) {
        String unsigned = Cookie.Signature.unsign(raw, this.secret);
        return Cookie.URL_DECODER.apply(unsigned);
    }

    private Route.After saveCookie() {
        return (req, rsp, result) -> {
            req.ifSession().ifPresent(session -> {
                Map<String, String> attributes;
                Optional<String> value = req.cookie(this.cookie.name().get()).toOptional();
                Map initial = value.map(this::attributes).orElse(Collections.emptyMap());
                boolean dirty = !initial.equals(attributes = session.attributes());
                this.log.debug("session dirty: {}", (Object)dirty);
                if (dirty) {
                    this.log.debug("saving session cookie");
                    String encoded = Cookie.URL_ENCODER.apply(attributes);
                    String signed = Cookie.Signature.sign(encoded, this.secret);
                    rsp.cookie(new Cookie.Definition(this.cookie).value(signed));
                } else if (this.timeout > 0L) {
                    value.ifPresent(raw -> rsp.cookie(new Cookie.Definition(this.cookie).value((String)raw)));
                }
            });
            return result;
        };
    }
}

