/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.TypeLiteral;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jooby.Parser;
import org.jooby.internal.Headers;

public enum BuiltinParser implements Parser
{
    Basic{
        private final Map<Class<?>, Function<String, Object>> parsers = ImmutableMap.builder().put(BigDecimal.class, NOT_EMPTY.andThen(BigDecimal::new)).put(BigInteger.class, NOT_EMPTY.andThen(BigInteger::new)).put(Byte.class, NOT_EMPTY.andThen(Byte::valueOf)).put(Byte.TYPE, NOT_EMPTY.andThen(Byte::valueOf)).put(Double.class, NOT_EMPTY.andThen(Double::valueOf)).put(Double.TYPE, NOT_EMPTY.andThen(Double::valueOf)).put(Float.class, NOT_EMPTY.andThen(Float::valueOf)).put(Float.TYPE, NOT_EMPTY.andThen(Float::valueOf)).put(Integer.class, NOT_EMPTY.andThen(Integer::valueOf)).put(Integer.TYPE, NOT_EMPTY.andThen(Integer::valueOf)).put(Long.class, NOT_EMPTY.andThen(this::toLong)).put(Long.TYPE, NOT_EMPTY.andThen(this::toLong)).put(Short.class, NOT_EMPTY.andThen(Short::valueOf)).put(Short.TYPE, NOT_EMPTY.andThen(Short::valueOf)).put(Boolean.class, NOT_EMPTY.andThen(this::toBoolean)).put(Boolean.TYPE, NOT_EMPTY.andThen(this::toBoolean)).put(Character.class, NOT_EMPTY.andThen(this::toCharacter)).put(Character.TYPE, NOT_EMPTY.andThen(this::toCharacter)).put(String.class, this::toString).build();

        @Override
        public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
            Function<String, Object> parser = this.parsers.get(type.getRawType());
            if (parser != null) {
                return ctx.param(values -> parser.apply((String)values.get(0))).body(body -> parser.apply(body.text()));
            }
            return ctx.next();
        }

        private String toString(String value) {
            return value;
        }

        private char toCharacter(String value) {
            return value.charAt(0);
        }

        private Boolean toBoolean(String value) {
            if ("true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Not a boolean: " + value);
        }

        private Long toLong(String value) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException ex) {
                try {
                    LocalDateTime date = LocalDateTime.parse(value, Headers.fmt);
                    Instant instant = date.toInstant(ZoneOffset.UTC);
                    return instant.toEpochMilli();
                }
                catch (DateTimeParseException ignored) {
                    throw ex;
                }
            }
        }
    }
    ,
    Collection{
        private final Map<Class<?>, Supplier<ImmutableCollection.Builder<?>>> parsers = ImmutableMap.builder().put(List.class, ImmutableList.Builder::new).put(Set.class, ImmutableSet.Builder::new).put(SortedSet.class, ImmutableSortedSet::naturalOrder).build();

        private boolean matches(TypeLiteral<?> toType) {
            return this.parsers.containsKey(toType.getRawType()) && toType.getType() instanceof ParameterizedType;
        }

        @Override
        public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
            if (this.matches(type)) {
                return ctx.param(values -> {
                    ImmutableCollection.Builder<?> builder = this.parsers.get(type.getRawType()).get();
                    TypeLiteral<?> paramType = TypeLiteral.get(((ParameterizedType)type.getType()).getActualTypeArguments()[0]);
                    for (Object value : values) {
                        builder.add(ctx.next(paramType, value));
                    }
                    return builder.build();
                });
            }
            return ctx.next();
        }
    }
    ,
    Optional{

        private boolean matches(TypeLiteral<?> toType) {
            return Optional.class == toType.getRawType() && toType.getType() instanceof ParameterizedType;
        }

        @Override
        public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
            if (this.matches(type)) {
                TypeLiteral<?> paramType = TypeLiteral.get(((ParameterizedType)type.getType()).getActualTypeArguments()[0]);
                return ctx.param(values -> {
                    if (values.size() == 0) {
                        return java.util.Optional.empty();
                    }
                    return java.util.Optional.of(ctx.next(paramType));
                }).body(body -> {
                    if (body.length() == 0L) {
                        return java.util.Optional.empty();
                    }
                    return java.util.Optional.of(ctx.next(paramType));
                });
            }
            return ctx.next();
        }
    }
    ,
    Enum{

        @Override
        public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
            Class<?> rawType = type.getRawType();
            if (Enum.class.isAssignableFrom(rawType)) {
                return ctx.param(values -> this.toEnum(rawType, (String)values.get(0))).body(body -> this.toEnum(rawType, body.text()));
            }
            return ctx.next();
        }

        Object toEnum(Class type, String value) {
            EnumSet set = EnumSet.allOf(type);
            return set.stream().filter(e -> e.name().equalsIgnoreCase(value)).findFirst().orElseGet(() -> java.lang.Enum.valueOf(type, value));
        }
    }
    ,
    Bytes{

        @Override
        public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
            if (type.getRawType() == byte[].class) {
                return ctx.body(body -> body.bytes());
            }
            return ctx.next();
        }

        public String toString() {
            return "byte[]";
        }
    };

}

