/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.base.Strings;
import com.typesafe.config.Config;
import java.util.Set;
import java.util.function.Function;
import org.jooby.Route;
import org.jooby.WebSocket;
import org.slf4j.Logger;

public class AppPrinter {
    private Set<Route.Definition> routes;
    private Set<WebSocket.Definition> sockets;
    private String[] urls;
    private boolean http2;
    private boolean h2cleartext;

    public AppPrinter(Set<Route.Definition> routes, Set<WebSocket.Definition> sockets, Config conf) {
        this.routes = routes;
        this.sockets = sockets;
        String host = conf.getString("application.host");
        String port = conf.getString("application.port");
        String path = conf.getString("application.path");
        this.urls = new String[2];
        this.urls[0] = "http://" + host + ":" + port + path;
        if (conf.hasPath("application.securePort")) {
            this.urls[1] = "https://" + host + ":" + conf.getString("application.securePort") + path;
        }
        this.http2 = conf.getBoolean("server.http2.enabled");
        this.h2cleartext = conf.getBoolean("server.http2.cleartext");
    }

    public void printConf(Logger log, Config conf) {
        if (log.isDebugEnabled()) {
            String desc = this.configTree(conf.origin().description());
            log.debug("config tree:\n{}", (Object)desc);
        }
    }

    private String configTree(String description) {
        return this.configTree(description.split(":\\s+\\d+,|,"), 0);
    }

    private String configTree(String[] sources, int i) {
        if (i < sources.length) {
            return Strings.padStart("", i, ' ') + "\u2514\u2500\u2500 " + sources[i] + "\n" + this.configTree(sources, i + 1);
        }
        return "";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.routes(buffer);
        String[] h2 = new String[]{this.h2(" ", this.http2 && this.h2cleartext), this.h2("", this.http2)};
        buffer.append("\nlistening on:");
        for (int i = 0; i < this.urls.length; ++i) {
            if (this.urls[i] == null) continue;
            buffer.append("\n  ").append(this.urls[i]).append(h2[i]);
        }
        return buffer.toString();
    }

    private String h2(String prefix, boolean h2) {
        return h2 ? prefix + " +h2" : "";
    }

    private void routes(StringBuilder buffer) {
        Function<Route.Definition, String> p = route -> {
            Route.Filter filter = route.filter();
            if (filter instanceof Route.Before) {
                return "{before}" + route.pattern();
            }
            if (filter instanceof Route.After) {
                return "{after}" + route.pattern();
            }
            if (filter instanceof Route.Complete) {
                return "{complete}" + route.pattern();
            }
            return route.pattern();
        };
        int verbMax = 0;
        int routeMax = 0;
        int consumesMax = 0;
        int producesMax = 0;
        for (Route.Definition route2 : this.routes) {
            verbMax = Math.max(verbMax, route2.method().length());
            routeMax = Math.max(routeMax, p.apply(route2).length());
            consumesMax = Math.max(consumesMax, route2.consumes().toString().length());
            producesMax = Math.max(producesMax, route2.produces().toString().length());
        }
        String format = "  %-" + verbMax + "s %-" + routeMax + "s    %" + consumesMax + "s     %" + producesMax + "s    (%s)\n";
        for (Route.Definition route3 : this.routes) {
            buffer.append(String.format(format, route3.method(), p.apply(route3), route3.consumes(), route3.produces(), route3.name()));
        }
        this.sockets(buffer, Math.max(verbMax, "WS".length()), routeMax, consumesMax, producesMax);
    }

    private void sockets(StringBuilder buffer, int verbMax, int routeMax, int consumesMax, int producesMax) {
        for (WebSocket.Definition socket : this.sockets) {
            routeMax = Math.max(routeMax, socket.pattern().length());
            consumesMax = Math.max(consumesMax, socket.consumes().toString().length() + 2);
            producesMax = Math.max(producesMax, socket.produces().toString().length() + 2);
        }
        String format = "  %-" + verbMax + "s %-" + routeMax + "s    %" + consumesMax + "s     %" + producesMax + "s\n";
        for (WebSocket.Definition socket : this.sockets) {
            buffer.append(String.format(format, "WS", socket.pattern(), "[" + socket.consumes() + "]", "[" + socket.produces() + "]"));
        }
    }
}

