/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.handlers;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.jooby.Asset;
import org.jooby.Env;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.handlers.AssetHandler;

public class SSIHandler
extends AssetHandler {
    private String startDelimiter = "<!--";
    private String endDelimiter = "-->";

    public SSIHandler(String pattern) {
        super(pattern);
    }

    public SSIHandler() {
        this("/");
    }

    public SSIHandler delimiters(String start, String end) {
        this.startDelimiter = start;
        this.endDelimiter = end;
        return this;
    }

    @Override
    protected void send(Request req, Response rsp, Asset asset) throws Throwable {
        Env env = req.require(Env.class);
        String text = this.process(env, this.text(asset.stream()));
        rsp.type(asset.type()).send(text);
    }

    private String process(Env env, String src) {
        return env.resolver().delimiters(this.startDelimiter, this.endDelimiter).source(key -> this.process(env, this.file(key))).ignoreMissing().resolve(src);
    }

    private String file(String key) {
        String file = Route.normalize(key.trim());
        return this.text(this.getClass().getResourceAsStream(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String text(InputStream stream) {
        try (InputStream in = stream;){
            String string = CharStreams.toString(new InputStreamReader(stream, StandardCharsets.UTF_8));
            return string;
        }
        catch (IOException | NullPointerException x) {
            throw new NoSuchElementException();
        }
    }
}

