/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.handlers;

import com.google.common.base.Strings;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.jooby.Asset;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.jooby.internal.URLAsset;

public class AssetHandler
implements Route.Handler {
    private static final Throwing.Function<String, String> prefix = AssetHandler.prefix().memoized();
    private Throwing.Function2<Request, String, String> fn;
    private Loader loader;
    private String cdn;
    private boolean etag = true;
    private long maxAge = -1L;
    private boolean lastModified = true;
    private int statusCode = 404;
    private String location;
    private Path basedir;
    private ClassLoader classLoader;

    public AssetHandler(String pattern, ClassLoader loader) {
        this.location = Route.normalize(pattern);
        this.basedir = Paths.get("public", new String[0]);
        this.classLoader = loader;
    }

    public AssetHandler(Path basedir) {
        this.location = "/{0}";
        this.basedir = basedir;
        this.classLoader = this.getClass().getClassLoader();
    }

    public AssetHandler(String pattern) {
        this.location = Route.normalize(pattern);
        this.basedir = Paths.get("public", new String[0]);
        this.classLoader = this.getClass().getClassLoader();
    }

    public AssetHandler etag(boolean etag) {
        this.etag = etag;
        return this;
    }

    public AssetHandler lastModified(boolean enabled) {
        this.lastModified = enabled;
        return this;
    }

    public AssetHandler cdn(String cdn) {
        this.cdn = Strings.emptyToNull(cdn);
        return this;
    }

    public AssetHandler maxAge(Duration maxAge) {
        return this.maxAge(maxAge.getSeconds());
    }

    public AssetHandler maxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public AssetHandler setRoute(Route.AssetDefinition route) {
        int i;
        String pattern;
        int i2;
        boolean rootLocation;
        boolean bl = rootLocation = this.location.equals("/") || this.location.equals("/{0}");
        String prefix = rootLocation ? ((i2 = (pattern = route.pattern()).indexOf("/*")) > 0 ? pattern.substring(0, i2 + 1) : pattern) : ((i = this.location.indexOf("{")) > 0 ? this.location.substring(0, i) : this.location);
        if (prefix.startsWith("/")) {
            prefix = prefix.substring(1);
        }
        if (prefix.isEmpty() && rootLocation) {
            throw new IllegalArgumentException("For security reasons root classpath access is not allowed. Map your static resources using a prefix like: assets(static/**); or use a location classpath prefix like: assets(/, /static/{0})");
        }
        this.init(prefix, this.location, this.basedir, this.classLoader);
        return this;
    }

    public AssetHandler maxAge(String maxAge) {
        Try.apply(() -> Long.parseLong(maxAge)).recover(x -> ConfigFactory.empty().withValue("v", ConfigValueFactory.fromAnyRef(maxAge)).getDuration("v").getSeconds()).onSuccess(this::maxAge);
        return this;
    }

    public AssetHandler onMissing(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public void handle(Request req, Response rsp) throws Throwable {
        String path = req.path();
        URL resource = this.resolve(req, path);
        if (resource != null) {
            URLAsset asset;
            String localpath = resource.getPath();
            int jarEntry = localpath.indexOf("!/");
            if (jarEntry > 0) {
                localpath = localpath.substring(jarEntry + 2);
            }
            if ((asset = new URLAsset(resource, path, MediaType.byPath(localpath).orElse(MediaType.octetstream))).exists()) {
                if (this.cdn != null) {
                    String absUrl = this.cdn + path;
                    rsp.redirect(absUrl);
                    rsp.end();
                } else {
                    this.doHandle(req, rsp, asset);
                }
            }
        } else if (this.statusCode > 0) {
            throw new Err(this.statusCode);
        }
    }

    private void doHandle(Request req, Response rsp, Asset asset) throws Throwable {
        long lastModified;
        if (this.etag) {
            String etag = asset.etag();
            boolean ifnm = req.header("If-None-Match").toOptional().map(etag::equals).orElse(false);
            if (ifnm) {
                rsp.header("ETag", (Object)etag).status(Status.NOT_MODIFIED).end();
                return;
            }
            rsp.header("ETag", (Object)etag);
        }
        if (this.lastModified && (lastModified = asset.lastModified()) > 0L) {
            boolean ifm = req.header("If-Modified-Since").toOptional(Long.class).map(ifModified -> lastModified / 1000L <= ifModified / 1000L).orElse(false);
            if (ifm) {
                rsp.status(Status.NOT_MODIFIED).end();
                return;
            }
            rsp.header("Last-Modified", (Object)new Date(lastModified));
        }
        if (this.maxAge > 0L) {
            rsp.header("Cache-Control", (Object)("max-age=" + this.maxAge));
        }
        this.send(req, rsp, asset);
    }

    protected void send(Request req, Response rsp, Asset asset) throws Throwable {
        rsp.send(asset);
    }

    private URL resolve(Request req, String path) throws Throwable {
        String target = this.fn.apply(req, path);
        return this.resolve(target);
    }

    protected URL resolve(String path) throws Exception {
        return this.loader.getResource(path);
    }

    private void init(String classPathPrefix, String location, Path basedir, ClassLoader loader) {
        Objects.requireNonNull(loader, "Resource loader is required.");
        this.fn = location.equals("/") ? (req, p) -> prefix.apply((String)p) : (req, p) -> MessageFormat.format(prefix.apply(location), AssetHandler.vars(req));
        this.loader = AssetHandler.loader(basedir, AssetHandler.classpathLoader(classPathPrefix, this.classLoader));
    }

    private static Object[] vars(Request req) {
        Map<Object, String> vars = req.route().vars();
        return vars.values().toArray(new Object[vars.size()]);
    }

    private static Loader loader(Path basedir, Loader classpath) {
        if (basedir != null && Files.exists(basedir, new LinkOption[0])) {
            return name -> {
                Path path = basedir.resolve(name).normalize();
                if (Files.exists(path, new LinkOption[0]) && path.startsWith(basedir)) {
                    try {
                        return path.toUri().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return classpath.getResource(name);
            };
        }
        return classpath;
    }

    private static Loader classpathLoader(String prefix, ClassLoader classloader) {
        return name -> {
            String safePath = AssetHandler.safePath(name);
            if (safePath.startsWith(prefix)) {
                URL resource = classloader.getResource(safePath);
                return resource;
            }
            return null;
        };
    }

    private static String safePath(String name) {
        if (name.indexOf("./") > 0) {
            Path path = AssetHandler.toPath(name.split("/")).normalize();
            return AssetHandler.toStringPath(path);
        }
        return name;
    }

    private static String toStringPath(Path path) {
        StringBuilder buffer = new StringBuilder();
        for (Path segment : path) {
            buffer.append("/").append(segment);
        }
        return buffer.substring(1);
    }

    private static Path toPath(String[] segments) {
        Path path = Paths.get(segments[0], new String[0]);
        for (int i = 1; i < segments.length; ++i) {
            path = path.resolve(segments[i]);
        }
        return path;
    }

    private static Throwing.Function<String, String> prefix() {
        return p -> p.substring(1);
    }

    private static interface Loader {
        public URL getResource(String var1);
    }
}

