/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.funzy;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.jooby.funzy.Throwing;

public class When<V> {
    private final V source;

    public When(V source) {
        this.source = source;
    }

    public static final <V> When<V> when(V value) {
        return new When<V>(value);
    }

    public <R> Value<V, R> is(V value, R result) {
        Value<V, R> when = new Value<V, R>(this.source);
        when.is(value, result);
        return when;
    }

    public <T extends V, R> Value<V, R> is(Class<T> predicate, R result) {
        Value when = new Value(this.source);
        when.is(predicate, result);
        return when;
    }

    public <R> Value<V, R> is(V value, Throwing.Supplier<R> result) {
        Value<V, R> when = new Value<V, R>(this.source);
        when.is(value, result);
        return when;
    }

    public <T extends V, R> Value<V, R> is(Class<T> predicate, Throwing.Function<T, R> result) {
        Value when = new Value(this.source);
        when.is(predicate, result);
        return when;
    }

    public <T extends V, R> Value<V, R> is(Throwing.Predicate<T> predicate, Throwing.Supplier<R> result) {
        Value when = new Value(this.source);
        when.is(predicate, result);
        return when;
    }

    public <T extends V, R> Value<V, R> is(Throwing.Predicate<T> predicate, Throwing.Function<T, R> result) {
        Value when = new Value(this.source);
        when.is(predicate, result);
        return when;
    }

    public static class Value<V, R> {
        private final V source;
        private final Map<Throwing.Predicate, Throwing.Function> predicates = new LinkedHashMap<Throwing.Predicate, Throwing.Function>();

        private Value(V source) {
            this.source = source;
        }

        public Value<V, R> is(V value, R result) {
            return this.is((T source) -> Objects.equals(source, value), (T v) -> result);
        }

        public <T extends V> Value<V, R> is(Class<T> predicate, R result) {
            return this.is(predicate::isInstance, (T v) -> result);
        }

        public Value<V, R> is(V value, Throwing.Supplier<R> result) {
            return this.is((T source) -> Objects.equals(source, value), (T v) -> result.get());
        }

        public <T extends V> Value<V, R> is(Class<T> predicate, Throwing.Function<T, R> result) {
            return this.is(predicate::isInstance, result);
        }

        public <T extends V> Value<V, R> is(Throwing.Predicate<T> predicate, Throwing.Supplier<R> result) {
            return this.is(predicate, (T v) -> result.get());
        }

        public <T extends V> Value<V, R> is(Throwing.Predicate<T> predicate, Throwing.Function<T, R> result) {
            this.predicates.put(predicate, result);
            return this;
        }

        public R get() {
            return this.toOptional().orElseThrow(NoSuchElementException::new);
        }

        public R orElse(R value) {
            return this.toOptional().orElse(value);
        }

        public R orElseGet(Throwing.Supplier<R> value) {
            return this.toOptional().orElseGet(value);
        }

        public R orElseThrow(Throwing.Supplier<Throwable> exception) {
            return this.toOptional().orElseThrow(() -> Throwing.sneakyThrow((Throwable)exception.get()));
        }

        public Optional<R> toOptional() {
            for (Map.Entry<Throwing.Predicate, Throwing.Function> predicate : this.predicates.entrySet()) {
                if (!predicate.getKey().test(this.source)) continue;
                return Optional.ofNullable(predicate.getValue().apply(this.source));
            }
            return Optional.empty();
        }
    }
}

