/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jooby.MediaType;
import org.jooby.Renderer;
import org.jooby.Result;

public class View
extends Result {
    private final String name;
    private final Map<String, Object> model = new HashMap<String, Object>();

    protected View(String name) {
        this.name = Objects.requireNonNull(name, "View name is required.");
        this.type(MediaType.html);
        super.set(this);
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    @Nonnull
    public View put(String name, Object value) {
        Objects.requireNonNull(name, "Model name is required.");
        this.model.put(name, value);
        return this;
    }

    @Nonnull
    public View put(Map<String, ?> values) {
        values.forEach((k, v) -> this.model.put((String)k, v));
        return this;
    }

    @Nonnull
    public Map<String, ?> model() {
        return this.model;
    }

    @Override
    @Nonnull
    public Result set(Object content) {
        throw new UnsupportedOperationException("Not allowed in views, use one of the put methods.");
    }

    public String toString() {
        return this.name + ": " + this.model;
    }

    public static interface Engine
    extends Renderer {
        @Override
        default public void render(Object value, Renderer.Context ctx) throws Exception {
            if (value instanceof View) {
                View view = (View)value;
                ctx.type(MediaType.html);
                this.render(view, ctx);
            }
        }

        public void render(View var1, Renderer.Context var2) throws FileNotFoundException, Exception;
    }
}

