/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jooby.MediaType;
import org.jooby.Result;
import org.jooby.Status;
import org.jooby.View;

public class Results {
    @Nonnull
    public static Result with(Object entity) {
        return new Result().set(entity);
    }

    @Nonnull
    public static Result with(Object entity, Status status) {
        return new Result().status(status).set(entity);
    }

    @Nonnull
    public static Result with(Object entity, int status) {
        return Results.with(entity, Status.valueOf(status));
    }

    @Nonnull
    public static Result with(Status status) {
        Objects.requireNonNull(status, "A HTTP status is required.");
        return new Result().status(status);
    }

    @Nonnull
    public static Result with(int status) {
        Objects.requireNonNull(Integer.valueOf(status), "A HTTP status is required.");
        return new Result().status(status);
    }

    @Nonnull
    public static Result ok() {
        return Results.with(Status.OK);
    }

    @Nonnull
    public static View html(String view) {
        return new View(view);
    }

    @Nonnull
    public static Result json(Object entity) {
        return Results.with(entity, 200).type(MediaType.json);
    }

    @Nonnull
    public static Result xml(Object entity) {
        return Results.with(entity, 200).type(MediaType.xml);
    }

    @Nonnull
    public static Result ok(Object entity) {
        return Results.ok().set(entity);
    }

    @Nonnull
    public static Result accepted() {
        return Results.with(Status.ACCEPTED);
    }

    @Nonnull
    public static Result accepted(Object content) {
        return Results.accepted().set(content);
    }

    @Nonnull
    public static Result noContent() {
        return Results.with(Status.NO_CONTENT);
    }

    @Nonnull
    public static Result redirect(String location) {
        return Results.redirect(Status.FOUND, location);
    }

    @Nonnull
    public static Result tempRedirect(String location) {
        return Results.redirect(Status.TEMPORARY_REDIRECT, location);
    }

    @Nonnull
    public static Result moved(String location) {
        return Results.redirect(Status.MOVED_PERMANENTLY, location);
    }

    @Nonnull
    public static Result seeOther(String location) {
        return Results.redirect(Status.SEE_OTHER, location);
    }

    @Nonnull
    public static Result when(String type, Supplier<Object> supplier) {
        return new Result().when(type, supplier);
    }

    @Nonnull
    public static Result when(MediaType type, Supplier<Object> supplier) {
        return new Result().when(type, supplier);
    }

    private static Result redirect(Status status, String location) {
        Objects.requireNonNull(location, "A location is required.");
        return Results.with(status).header("location", (Object)location);
    }
}

