/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.Throwables;
import com.typesafe.config.Config;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.jooby.Env;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Results;
import org.jooby.Status;
import org.jooby.WebSocket;
import org.jooby.funzy.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Err
extends RuntimeException {
    private int status;

    public Err(Status status, String message, Throwable cause) {
        super(Err.message(status, message), cause);
        this.status = status.value();
    }

    public Err(int status, String message, Throwable cause) {
        super(Err.message("", status, message), cause);
        this.status = status;
    }

    public Err(WebSocket.CloseStatus status, String message) {
        super(Err.message(status.reason(), status.code(), message));
        this.status = status.code();
    }

    public Err(Status status, String message) {
        super(Err.message(status, message));
        this.status = status.value();
    }

    public Err(int status, String message) {
        this(Status.valueOf(status), message);
    }

    public Err(Status status, Throwable cause) {
        super(Err.message(status, null), cause);
        this.status = status.value();
    }

    public Err(int status, Throwable cause) {
        this(Status.valueOf(status), cause);
    }

    public Err(Status status) {
        super(Err.message(status, null));
        this.status = status.value();
    }

    public Err(int status) {
        this(Status.valueOf(status));
    }

    public int statusCode() {
        return this.status;
    }

    public Map<String, Object> toMap() {
        return this.toMap(false);
    }

    public Map<String, Object> toMap(boolean stacktrace) {
        Status status = Status.valueOf(this.status);
        Throwable cause = Optional.ofNullable(this.getCause()).orElse(this);
        String message = Optional.ofNullable(cause.getMessage()).orElse(status.reason());
        LinkedHashMap<String, Object> err = new LinkedHashMap<String, Object>();
        err.put("message", message);
        if (stacktrace) {
            err.put("stacktrace", Throwables.getStackTraceAsString(cause).replace("\r", "").split("\\n"));
        }
        err.put("status", status.value());
        err.put("reason", status.reason());
        return err;
    }

    private static String message(Status status, @Nullable String tail) {
        return Err.message(status.reason(), status.value(), tail);
    }

    private static String message(String reason, int status, @Nullable String tail) {
        return reason + "(" + status + ")" + (tail == null ? "" : ": " + tail);
    }

    public static interface Handler {
        public void handle(Request var1, Response var2, Err var3) throws Throwable;
    }

    public static class DefHandler
    implements Handler {
        public static final String VIEW = "err";
        private final Logger log = LoggerFactory.getLogger(Err.class);

        @Override
        public void handle(Request req, Response rsp, Err ex) throws Throwable {
            this.log.error("execution of: {}{} resulted in exception\nRoute:\n{}\n\nStacktrace:", new Object[]{req.method(), req.path(), req.route().print(6), ex});
            Config conf = req.require(Config.class);
            Env env = req.require(Env.class);
            boolean stackstrace = Try.apply(() -> conf.getBoolean("err.stacktrace")).orElse(env.name().equals("dev"));
            Function<Object, String> xssFilter = env.xss("html").compose(Objects::toString);
            BiFunction<String, Object, String> escaper = (k, v) -> (String)xssFilter.apply(v);
            Map<String, Object> details = ex.toMap(stackstrace);
            details.compute("message", escaper);
            details.compute("reason", escaper);
            rsp.send(Results.when(MediaType.html, () -> Results.html(VIEW).put(VIEW, details)).when(MediaType.all, () -> details));
        }
    }

    public static class Missing
    extends Err {
        public Missing(String name) {
            super(Status.BAD_REQUEST, name);
        }
    }

    public static class BadMediaType
    extends Err {
        public BadMediaType(String message) {
            super(Status.BAD_REQUEST, message);
        }
    }
}

